<?php

namespace Teknisa\Libs\Controller;

use Zeedhi\Framework\Controller\Simple;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Framework\DataSource\DataSet;
use Teknisa\Libs\Service\ZhuLog as ZhuLogService;

class ZhuLog extends Simple {
    /** @var ZhuLogService $zhuLogService */
    private $zhuLogService;

    public function __construct(ZhuLogService $zhuLogService) {
        $this->zhuLogService = $zhuLogService;
    }
    
    public function find(Request\Filter $request, Response $response) {
        try {
            $conditions = $request->getFilterCriteria()->getConditions();
            $page       = $request->getFilterCriteria()->getPage();
            $pageSize   = $request->getFilterCriteria()->getPageSize();
            $orderBy    = $request->getFilterCriteria()->getOrderBy();
            $zhuLog     = $this->zhuLogService->find($conditions, $page, $pageSize, $orderBy);
            $response->addDataSet(new DataSet('zhuLog', $zhuLog));
        } catch(\Exception $e) {
            $response->setError(new Response\Error($e->getMessage(), 500));
            $response->addMessage(new Response\Message($e->getMessage(), Response\Message::TYPE_ERROR));
        }
    }
} 