<?php

namespace Teknisa\Libs\Util\Masks;

use Teknisa\Libs\Util\Repositories\General;

class PictureProduto extends Picture {
    const PICTURE = 'CDPICTPROD';

    public function __construct($nrorg) {
        parent::__construct($nrorg, $this::PICTURE);
    }

    public static function isProdutoNivelMaximo($cdproduto, $nrorg, $nivel = null) {
        if(empty($nivel)) {
            $produto = General::getProductByCodeAndOrganizationId($cdproduto, $nrorg);
            if(empty($produto)) {
                throw new \Exception("Produto não encontrado.", 500);
            }
            $nivel = $produto['CDNVPRODUTO'];
        }
        return ($nivel == self::retornaNumeroMaximoDeNiveis($nrorg));
    }

    public static function retornaNumeroMaximoDeNiveis($nrorg) {
        $picture = new self($nrorg);
        return $picture->getNumeroDeNiveis();
    }

    /**
     * Mascara do produto.
     *
     * @return mixed
     */
    public static function mascaraProduto($nrorg){
        $pic = new self($nrorg);
        return $pic->getMascara();
    }
}