<?php

namespace Teknisa\Libs\Util;

use Teknisa\Libs\Util\Messages;

class RotiGeraAF {

    const LimAF        = '08'; //{Valor da AF acima do limite}
    const LimAFMes     = '09'; //{Valor das AF's no mês acima do limite}
    const QtMiForn     = '10'; //{Qt. Total da AF abaixo da Qt. mínima para o fornecedor.}
    const VrMiForn     = '11'; //{Valor Total da AF abaixo do mínimo para o fornecedor.}
    const LimAFPro     = '12'; //{Valor dos produtos da AF acima do limite do comprador.}
    const LimAFPrM     = '13'; //{Valor dos produtos da AF no mês acima do limite do comprador.}
    const QtMiFoPr     = '14'; //{Qt. do produto abaixo do mínimo para o fornecedor.}
    const QtArrPrF     = '15'; //{Qt. do Produto não atende ao arredondamento do fornecedor}
    const PartProd     = '16'; //{Produto não atende às particularidades do produto}
    const ProdPrefMed  = '17'; //{Produto comprado não é o preferencial.}
    const QtMiFornReg  = '18'; //{Qt. Total da AF abaixo da Qt. mínima para o fornecedor na região.}
    const VrMiFornReg  = '19'; //{Valor Total da AF abaixo do mínimo para o fornecedor na região.}
    const VrOrcaFili   = '20'; //{Valor do Orçamento da filial para consumo ultrapassado.}
    const QtMinCotacao = '21'; //{Qt. Minima de Cotação para o produto}
    const QtPrecObjet  = '22'; //{Valor do item maior que o preço objetivo}
    const VrDespFili   = '23'; //{Valor do Orçamento da filial para despesa ultrapassado.}
    const LimAFNVPro   = '24'; //{Valor por nível dos produtos da AF acima do limite do comprador.}
    const LimAFNVPrM   = '25'; //{Valor por nível dos produtos da AF no mês acima do limite do comprador.}
        
    const msgPadrao = array (
        '09'   => Messages::ERR_VAL_AF_MAX_COMP,
        
        '10'   => Messages::ERR_QUANT_TOT_AF_MIN_FOR,
    
        '11'   => Messages::ERR_VAL_TOT_AF_MIN_FOR,
        
        '12'   => Messages::ERR_VAL_PROC_MAX_COMP,
    
        '13'   => Messages::ERR_VAL_PROD_MES_MAX_COMP,
        
        '14'   => Messages::ERR_QUANT_PROD_MIN_FOR,
    
        '15'   => Messages::ERR_QUANT_PROD_N_ATENDE_ARR_FOR,
    
        '16-1' => Messages::ERR_MARCA_OBR, 
    
        '16-2' => Messages::ERR_MARCA_PREF, 
    
        '16-3' => Messages::ERR_RESTR_MARCA, 
    
        '16-4' => Messages::ERR_FOR_OBR, 
    
        '16-5' => Messages::ERR_FOR_PREF, 
    
        '16-6' => Messages::ERR_RESTR_FOR, 
    
        '16-7' => Messages::ERR_MARCA_FOR_OBR, 
    
        '16-8' => Messages::ERR_MARCA_FOR_PREF, 
    
        '16-9' => Messages::ERR_RESTR_MARCA_FOR, 
    
        '17'   => Messages::ERR_PROD_PREF, 
    
        '18'   => Messages::ERR_QUANT_TOT_AF_MIN_FOR_REG,
    
        '19'   => Messages::ERR_VAL_TOT_AF_MIN_FOR_REG,
            
        '20'   => Messages::ERR_ORC_FIL_CONS_ULTR,
    
        '21'   => Messages::ERR_QUANT_COT_PROD_MIN,
    
        '22'   => Messages::ERR_PREC_UNI_EST_ACIMA,
    
        '23'   => Messages::ERR_ORC_FIL_DESP_ULTR,
    
        '24'   => Messages::ERR_VAL_NVL_PROD_MAX_COMP,
            
        '25'   => Messages::ERR_VAL_NVL_PROD_MES_MAX_COMP,
          
    ); 
    
    protected $connection;
    protected $entityManager;
    protected $repository;
    var $cdsDadosAF;
    
    public function __construct($connection, $entityManager, Repositories\RotiGeraAFData $libRotiGeraAFRepository) {
        $this->connection       = $connection;
        $this->entityManager    = $entityManager;
        $this->repository       = $libRotiGeraAFRepository;
    }
    
    public function inconsLimAF($stFilDest, $stFilLanc, $stNrAF, $stOper, $boGravaIncons){
        $i = 0;
        
        $adqRelValor_AF = $this->repository->adqRelValor_AF($stFilDest, $stFilLanc, $stNrAF);
        $adqRelValor_AF_Mes = $this->repository->adqRelValor_AF_Mes($stFilDest, $stFilLanc, $stNrAF, $stOper);
        $adqRelQuant_TotalAF = $this->repository->adqRelQuant_TotalAF($stFilDest, $stFilLanc, $stNrAF);
        $adqRelQuant_FornReg = $this->repository->adqRelQuant_FornReg($stFilDest, $stFilLanc, $stNrAF);
        $adqRelValorAF_MinForn = $this->repository->adqRelValorAF_MinForn($stFilDest, $stFilLanc, $stNrAF);
        $adqRelValorAF_MinFornReg = $this->repository->adqRelValorAF_MinFornReg($stFilDest, $stFilLanc, $stNrAF);
        
        $i = $this->validaValoresAF($adqRelValor_AF, $adqRelValor_AF_Mes, $adqRelQuant_TotalAF, $adqRelQuant_FornReg, $adqRelValorAF_MinForn, $adqRelValorAF_MinFornReg);
        
        $this->repository->CONSISTE_ORCAMENTO($stFilDest, $stFilLanc, $stNrAF);
        $adqCentCompra = $this->repository->adqCentCompra($stFilDest);
        $adqParaSupriCentCmp = $this->repository->adqParaSupriCentCmp($adqCentCompra['CDFILCENTCMP']);
        $adqRelProdutos = $this->repository->adqRelProdutos($stFilDest, $stFilLanc, $stNrAF);
        $adqParametro = $this->repository->adqParametro($stFilDest);
        
        foreach ($adqRelProdutos as $value){

            $adqRelValorAF_Prod = $this->repository->adqRelValorAF_Prod($stFilDest, $stFilLanc, $stNrAF, $stOper, $value['CDPRODUTO']);
            $adqRelValorAF_ProdMes = $this->repository->adqRelValorAF_ProdMes($stFilDest, $stFilLanc, $stNrAF, $stOper, $value['CDPRODUTO']);
            $adqLimNvAf = $this->repository->adqLimNvAf($stOper, $value['CDARVPROD']);
            $adqRelQuant_ProdForn = $this->repository->adqRelQuant_ProdForn($stFilDest, $stFilLanc, $stNrAF, $value['CDPRODUTO']);
            $adqRelVrArredCmpForn = $this->repository->adqRelVrArredCmpForn($stFilDest, $stFilLanc, $stNrAF, $value['CDPRODUTO']);
            
            $i = $this->validaValoresAFPorProduto($i, $value, $adqRelValorAF_Prod, $adqRelValorAF_ProdMes, $adqLimNvAf, $adqRelQuant_ProdForn, $adqRelVrArredCmpForn);
            
            $adqRelParticularidades = $this->repository->adqRelParticularidades($stFilDest, $stFilLanc, $stNrAF, $value['CDPRODUTO']);

            foreach ($adqRelParticularidades as $particularidades){
                if($particularidades['Particular'] == '4'){
                    if($adqParametro[0]['IDUTILCONSSOLIOL'] == 'N'){
                        if($value['IDAUTOFORNEX'] == 'S'){
                            $adqParamProdSup = $this->repository->adqParamProdSup($stFilDest, $value['CDPRODUTO']);
                            
                            if(empty($adqParamProdSup) == true){
                                $adqFornecedorObrig = $this->repository->adqFornecedorObrig($stFilDest, $stFilLanc, $stNrAF, $value['CDPRODUTO'], $particularidades['Fornecedor']);

                                if(empty($adqFornecedorObrig) == false){
                                    $this->ifcdDadosAF($i, PartProd, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], $particularidades['Particular'], $particularidades['Fornecedor'], $particularidades['Marca'], $particularidades['NMMARCA'], $particularidades['NMRAZSOCFORN'], '', '', '', '');
                                    $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
                                    $i ++;        
                                }
                            }
                        }else{
                            $adqFornecedorObrig = $this->repository->adqFornecedorObrig($stFilDest, $stFilLanc, $stNrAF, $value['CDPRODUTO'], $particularidades['Fornecedor']);

                            if(empty($adqFornecedorObrig) == false){
                                $this->ifcdDadosAF($i, PartProd, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], $particularidades['Particular'], $particularidades['Fornecedor'], $particularidades['Marca'], $particularidades['NMMARCA'], $particularidades['NMRAZSOCFORN'], '', '', '', '');
                                $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
                                $i ++;        
                            }
                        }
                    }else{
                        $adqFornecedorObrig = $this->repository->adqFornecedorObrig($stFilDest, $stFilLanc, $stNrAF, $value['CDPRODUTO'], $particularidades['Fornecedor']);

                        if(empty($adqFornecedorObrig) == false){
                            $this->ifcdDadosAF($i, PartProd, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], $particularidades['Particular'], $particularidades['Fornecedor'], $particularidades['Marca'], $particularidades['NMMARCA'], $particularidades['NMRAZSOCFORN'], '', '', '', '');
                            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
                            $i ++;        
                        }                        
                    }
                }else{
                    $this->ifcdDadosAF($i, PartProd, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], $particularidades['Particular'], $particularidades['Fornecedor'], $particularidades['Marca'], $particularidades['NMMARCA'], $particularidades['NMRAZSOCFORN'], '', '', '', '');
                    $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
                    $i ++;      
                }
            }
            $adqRelProdPrefMed = $this->repository->adqRelProdPrefMed($stFilDest, $value['CDPRODESTO']);
            
            if(empty($adqRelProdPrefMed) == false){
                $this->ifcdDadosAF($i, ProdPrefMed, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], '', '', '', '', '', '', $adqRelProdPrefMed[0]['NMPRODPREF'], '', '');
                $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
                $i ++;        
            } 
            
            $adqVerificaParametro = $this->repository->adqVerificaParametro($stFilDest);
            
            if($adqVerificaParametro[0]['IDCONSAFORCFIL'] == 'S'){
                $adqRelConsisteOrca = $this->repository->adqRelConsisteOrca ($stFilDest, $stFilLanc, $stNrAF, $value['CDPRODUTO']);
                
                if(empty($adqRelConsisteOrca) == false){
                    $stDsErro      = '';
                    $dbVrOrcamento = 0;
                    $dbVrUtilizado = 0;
                    $stErroBanco   = $adqRelConsisteOrca[0]['DSERROCONSORCA'];
                    $stErroBancoId = substr ($stErroBanco , 25, 8 );
                    $stErroBancoId = trim($stErroBancoId. ' ');
                    $stDsErro      = $adqRelConsisteOrca[0]['DSERROCONSORCA'];
                    $dbVrOrcamento = substr($stDsErro, strpos('do:', $stDsErro)+3, (strpos('.V', $stDsErro)-(strpos('do:', $stDsErro)+3)));
                    $dbVrUtilizado = substr($stDsErro, strpos('AF:', $stDsErro)+3, (strlen($stDsErro)-(strpos('AF:', $stDsErro)+3)));

                    if($stErroBancoId == 'despesa'){
                        $this->ifcdDadosAF($i, VrDespFili, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], '', '', '', '', '', '', '', '', '');
                    }else{
                        $this->ifcdDadosAF($i, VrOrcaFili, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], '', '', '', '', '', '', '', '', '');
                    }
                    $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $dbVrOrcamento, $dbVrUtilizado, $this->cdsDadosAF[$i]);
                    $i ++;        
                }
            }
            if($adqParaSupriCentCmp[0]['IDQTCOTPROD'] == 'S'){
                $adqQntCotProd = $this->repository->adqQntCotProd($adqCentCompra[0]['CDFILCENTCMP'], $value['CDARVPROD']);
                
                if(empty($adqQntCotProd) == false){
                    $adqVerificaQntCot = $this->repository->adqVerificaQntCot($stFilDest, $value['CDPRODUTO'], $adqCentCompra[0]['CDFILCENTCMP'], $value['DTPROGENTAF']);
                
                    if($adqQntCotProd[0]['VRQTDCOTACAO'] > $adqVerificaQntCot[0]['QTDCOTACAO']){
                        $this->ifcdDadosAF($i, QtMinCotacao, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], '', '', '', '', '', '', '', $adqVerificaQntCot[0]['QTDCOTACAO'], $adqQntCotProd[0]['VRQTDCOTACAO']);
                        $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
                        $i ++;      
                    }
                } 
            }
            $adqPrecObjet = $this->repository->adqPrecObjet($stFilDest, $value['CDPRODESTO'], $value['DTPROGENTAF']);
            
            if($adqPrecObjet[0]['VRPRECOBJETIVO'] > 0){
                if($adqPrecObjet[0]['VRPRECOBJETIVO'] < (floatval($value['VRPREUNIAF'])/floatval($value['VRFATOCONV']))){
                    $this->ifcdDadosAF($i, QtPrecObjet, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], '', '', '', '', '', '', '', $value['VRPREUNIAF'], $adqPrecObjet[0]['VRPRECOBJETIVO']);
                    $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
                    $i ++;      
                }
            }
        }
        $varResult = array (
            '0' => '',
            '1' => '',
            '2' => '',
            '3' => ''
        );
        $varAux = array(
            '0' => array(),
            '1' => array(),
            '2' => array()
        );
        $indice = 0;
        
        if($boGravaIncons == true){
            $this->gravarIconsistenciaVerdadeiro($adqRelProdutos, $stFilDest, $stFilLanc, $stNrAF);
        }
        else{
           return $this->gravarIconsistenciaFalso($indice, $adqRelProdutos, $stFilDest, $stFilLanc, $stNrAF);
        }
    }

    public function validaValoresAF ($i, $adqRelValor_AF, $adqRelValor_AF_Mes, $adqRelQuant_TotalAF, $adqRelQuant_FornReg, $adqRelValorAF_MinForn, $adqRelValorAF_MinFornReg){
         if(empty($adqRelValor_AF) == false){
            $this->ifcdDadosAF($i, LimAF, '', '', '', '', '', '', '', '', '', '', $adqRelValor_AF[0]['VRTOTALAF'], $adqRelValor_AF[0]['VRLIMAFCOMP']);
            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
            $i++;
        }
        
        if(empty($adqRelValor_AF_Mes) == false){
            $this->ifcdDadosAF($i, LimAF, '', '', '', '', '', '', '', '', '', '', $adqRelValor_AF_Mes[0]['SOMAAF'], $adqRelValor_AF[0]['VRLIMAFMES']);
            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
            $i ++;        
        }
        
        if(empty($adqRelQuant_TotalAF) == false){
            $this->ifcdDadosAF($i, QtMiForn, '', '', '', '', '', '', '', '', '', '', $adqRelQuant_TotalAF[0]['Quant_total'], $adqRelQuant_TotalAF[0]['QTMINAUTFOT']);
            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
            $i ++;        
        } 
        
        if(empty($adqRelQuant_FornReg) == false){
            $this->ifcdDadosAF($i, QtMiFornReg, '', '', '', '', '', '', '', '', '', '', $adqRelQuant_FornReg[0]['Quant_total'], $adqRelQuant_FornReg[0]['QTMINFORNREG']);
            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
            $i ++;        
        }
        
        if(empty($adqRelValorAF_MinForn) == false){
            $this->ifcdDadosAF($i, VrMiForn, '', '', '', '', '', '', '', '', '', '', $adqRelValorAF_MinForn[0]['VRTOTALAF'], $adqRelValorAF_MinForn[0]['VRMINAUTFOR']);
            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
            $i ++;        
        }
        
        if(empty($adqRelValorAF_MinFornReg) == false){
            $this->ifcdDadosAF($i, VrMiFornReg, '', '', '', '', '', '', '', '', '', '', $adqRelValorAF_MinFornReg[0]['VRTOTALAF'], $adqRelValorAF_MinFornReg[0]['VRMINFORNREG']);
            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
            $i ++;        
        } 
        return $i;

    }

    public function validaValoresAFPorProduto ($i, $adqRelValor_AF, $adqRelValor_AF_Mes, $adqRelQuant_TotalAF, $adqRelQuant_FornReg, $adqRelValorAF_MinForn, $adqRelValorAF_MinFornReg){
    
        if(empty($adqRelValorAF_Prod) == false){
            $this->ifcdDadosAF($i, LimAFPro, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], '', '', '', '', '', '', '', $adqRelValorAF_Prod[0]['SOMAAF'], $adqRelValorAF_Prod[0]['VRLIMPRODAF']);
            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
            $i ++;        
        }
        if(empty($adqRelValorAF_ProdMes) == false){
            $this->ifcdDadosAF($i, LimAFPrM, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], '', '', '', '', '', '', '', $adqRelValorAF_ProdMes[0]['SOMAAF'], $adqRelValorAF_ProdMes[0]['VRLIMPRAFMES']);
            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
            $i ++;        
        } 
        
        if(strlen($adqLimNvAf[0]['CDARVPROD'])>0){
            $adqRelValorAF_NVProd = $this->repository->adqRelValorAF_NVProd($stFilDest, $stFilLanc, $stNrAF, $adqLimNvAf[0]['CDARVPROD']);
                if(empty($adqRelValorAF_NVProd) == false){
                $this->ifcdDadosAF($i, LimAFNVPro, $value['CDPRODUTO'], '', $value['CDARVPROD'], '', '', '', '', '', '', '', $adqRelValorAF_NVProd[0]['SOMAAF'], $adqRelValorAF_NVProd[0]['VRLIMNIVELAF']);
                $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
                $i ++;        
            } 
            $adqRelValorAF_NVProdMes = $this->repository->adqRelValorAF_NVProdMes($stOper, $adqLimNvAf[0]['CDARVPROD']);
            if(empty($adqRelValorAF_NVProdMes) == false){
                $this->ifcdDadosAF($i, LimAFNVPrM, $value['CDPRODUTO'], '', $value['CDARVPROD'], '', '', '', '', '', '', '', $adqRelValorAF_NVProdMes[0]['SOMAAF'], $adqRelValorAF_NVProdMes[0]['VRLIMNIVPRAFMES']);
                $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
                $i ++;        
            }
        }
        if(empty($adqRelQuant_ProdForn) == false){
            $this->ifcdDadosAF($i, QtMiFoPr, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], '', '', '', '', '', '', '', $adqRelQuant_ProdForn[0]['QUANT_PROD'], $adqRelQuant_ProdForn[0]['QTMINAF']);
            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
            $i ++;        
        } 
        if(empty($adqRelVrArredCmpForn) == false){
            $this->ifcdDadosAF($i, QtArrPrF, $value['CDPRODUTO'], $value['NMPRODUTO'], $value['CDARVPROD'], '', '', $adqRelVrArredCmpForn[0]['CDMARCA'], $adqRelVrArredCmpForn[0]['NMMARCA'], '', $adqRelVrArredCmpForn[0]['DTPROGENTAF'], '', $adqRelVrArredCmpForn[0]['QTPROGENTAF'], $adqRelVrArredCmpForn[0]['VRARREDCMPFO']);
            $this->cdsDadosAF[$i]['DSERRO'] = $this->montaFrase($this->cdsDadosAF[$i]['CDERRO'], $this->cdsDadosAF[$i]['CDPARTFILI'], $this->cdsDadosAF[$i]['VR1'], $this->cdsDadosAF[$i]['VR2'], $this->cdsDadosAF[$i]);
            $i ++;        
        }
        return $i;
    }

    public function gravarIconsistenciaVerdadeiro($adqRelProdutos, $stFilDest, $stFilLanc, $stNrAF){
        $stSituAtuaAF = '';
        $stAFForaLim = 'N';
        $stErro = ' ';
        $stErroItm = ' ';
        $this->repository->acmLimpaInconsAF($stFilDest, $stFilLanc, $stNrAF);
        $this->repository->acmLimpaInconsItAf($stFilDest, $stFilLanc, $stNrAF);
            foreach ($adqRelProdutos as $value){
            $stErroItm = '';
            
            foreach ($this->cdsDadosAF as $dados) {
                if($dados['CDERRO'] == LimAF || $dados['CDERRO'] == LimAFMes ||
                   $dados['CDERRO'] == LimAFPro || $dados['CDERRO'] == LimAFPrM ||
                   $dados['CDERRO'] == VrOrcaFili || $dados['CDERRO'] == VrDespFili ||
                   $dados['CDERRO'] == LimAFNVPro || $dados['CDERRO'] == LimAFNVPrM ){
                       $stAFForaLim = 'S';
                    }
                
                if($dados['CDERRO'] == QtMiForn || $dados['CDERRO'] == VrMiForn ||
                   $dados['CDERRO'] == QtMiFoPr || $dados['CDERRO'] == QtArrPrF ||
                   $dados['CDERRO'] == PartProd || $dados['CDERRO'] == ProdPrefMed ||
                   $dados['CDERRO'] == QtMiFornReg || $dados['CDERRO'] == VrMiFornReg || 
                   $dados['CDERRO'] == QtMinCotacao || $dados['CDERRO'] == QtPrecObjet){
                       $stSituAtuaAF = '1';
                }
                
                if($dados['CDERRO'] < '12'){
                    if((strpos($dados['DSERRO'], $stErro) > 0) == false){
                        $stErro = $stErro + $dados['DSERRO'] + "/n" + "/n";
                    }
                    $acmInconsAF = $this->repository->acmInconsAF($stFilDest, $stFilLanc, $stNrAF, $stErro);
                }
                
                if($dados['CDERRO'] >= '12'){
                    if(empty($dados['CDPRODUTO']) == true || $value['CDPRODUTO'] == $dados['CDPRODUTO']){
                        if((strpos($dados['DSERRO'], $stErroItm) > 0) == false){
                            $stErroItm = $stErroItm + $dados['DSERRO'] + "/n" + "/n";
                        }
                    }
                }
            }
            if($stErroItm !== ''){
                $this->repository->acmInconsItAF($stFilDest, $stFilLanc, $stNrAF, $stErroItm, $value['CDMARCA'], $value['CDPRODUTO']);
            }
        }
        $this->repository->acmGravaInconsLimAF($stFilDest, $stFilLanc, $stNrAF, $stSituAtuaAF, $stAFForaLim);
    }
    
    public function gravarIconsistenciaFalso($indice, $adqRelProdutos, $stFilDest, $stFilLanc, $stNrAF){
        $stSituAtuaAF = '';
        $stAFForaLim  = 'N';
        $this->repository->acmLimpaInconsAF($stFilDest, $stFilLanc, $stNrAF);
        $this->repository->acmLimpaInconsItAf($stFilDest, $stFilLanc, $stNrAF);
        
        foreach ($this->cdsDadosAF as $dados) {
            
            if($dados['CDERRO'] == LimAF || $dados['CDERRO'] == LimAFMes ||
                $dados['CDERRO'] == LimAFPro || $dados['CDERRO'] == LimAFPrM ||
                $dados['CDERRO'] == VrOrcaFili ){
                $stAFForaLim = 'S';
            }
            
            if($dados['CDERRO'] == QtMiForn || $dados['CDERRO'] == VrMiForn ||
               $dados['CDERRO'] == QtMiFoPr || $dados['CDERRO'] == QtArrPrF ||
               $dados['CDERRO'] == PartProd || $dados['CDERRO'] == ProdPrefMed ||
               $dados['CDERRO'] == QtMiFornReg || $dados['CDERRO'] == VrMiFornReg || 
               $dados['CDERRO'] == QtMinCotacao){
               $stSituAtuaAF = '1';
            }
            
            if($dados['CDERRO'] < '12'){
                $varResult [2] = $varResult[2] + $dados['DSERRO'] + "/n" + "/n";
            }
            
            if($dados['CDERRO'] >= '12'){
                $varAux[0][$indice] = $dados['CDMARCA'];
                $varAux[1][$indice] = $dados['CDPRODUTO'];
                $varAux[2][$indice] = $varAux[2][$i] + $dados['DSERRO'] + "/n" + "/n";
                $indice ++;
            }
        }
    
        $varResult[0] = $stAFForaLim;
        $varResult[1] = $stSituAtuaAF;
        $varResult[3] = $varAux;
        return $varResult;
    }

    public function ifcdDadosAF($i, $cderro, $cdproduto, $nmproduto, $cdarvprod, $cdpartifili, $cdforneced, $cdmarca, $nmmarca, $nmrazsocforn, $dtprogentaf, $nmprodpref, $vr1, $vr2){
        
            $this->cdsDadosAF[$i]['CDERRO']           = $cderro;
            $this->cdsDadosAF[$i]['CDPRODUTO']        = $cdproduto;
            $this->cdsDadosAF[$i]['NMPRODUTO']        = $nmproduto;
            $this->cdsDadosAF[$i]['CDARVPROD']        = $cdarvprod;
            $this->cdsDadosAF[$i]['CDPARTFILI']       = $cdpartifili;
            $this->cdsDadosAF[$i]['CDFORNECED']       = $cdforneced;
            $this->cdsDadosAF[$i]['CDMARCA']          = $cdmarca;
            $this->cdsDadosAF[$i]['NMMARCA']          = $nmmarca;
            $this->cdsDadosAF[$i]['NMRAZSOCFORN']     = $nmrazsocforn;
            $this->cdsDadosAF[$i]['DTPROGENTAF']      = $dtprogentaf;
            $this->cdsDadosAF[$i]['NMPRODPREF']       = $nmprodpref;
            $this->cdsDadosAF[$i]['VR1']              = $vr1;
            $this->cdsDadosAF[$i]['VR2']              = $vr2;
    }
    
    public function montaFrase($stErro, $stPartFili, $exVR1, $exVR2, $cdsAux) {
        
        if($stErro === '16'){
            if($stPartFili[0] >= '1' && $stPartFili[0] <= '3'){
                $result = msgPadrao['16-'+ $stPartFili[0]][0] + $cdsAux['NMMARCA']; 
            }
            else if($stPartFili[0] >= '4' && $stPartFili[0] <= '6'){
                $result = msgPadrao['16-'+ $stPartFili[0]][0] + $cdsAux['NMRAZSOCFORN']; 
            }
            else if($stPartFili[0] >= '7' && $stPartFili[0] <= '9'){
                $result = msgPadrao['16-'+ $stPartFili[0]][0] + $cdsAux['NMMARCA'] + ' ' + $cdsAux['NMRAZSOCFORN']; 
            }
            else {
                $result = '';
            }
        }
        else if($stErro === '17'){
            $result = msgPadrao['17'][0] + $cdsAux['NMPRODPREF']; 
        }
        else {
            if ($stErro === '10' || $stErro === '14' || $stErro === '15' || $stErro === '18'){
                $stMasc = '###,##0.000';
            }
            else{
                $stMasc = '#,###,##0.00';
            }
            $msg = msgPadrao[$stPartFili[0]][0];
            $porc1 = $this->mask($stMasc, $exVR1);
            $msg =  str_replace("*", $msg, $porc1);
            $porc2 = $this->mask($stMasc, $exVR2);
            $msg =  str_replace("@", $msg, $porc1);
            $result = $msg;
        }
        return $result;
    }
    
    function mask($mask,$str){

        $str = str_replace(".","",$str);

        return  vsprintf($mask, str_split($str));
    }
    

}