<?php

namespace Teknisa\Libs\Util\Login;

interface UserData {
    /**
     * @param $user
     * @param $password
     * @return array
     *
     * The return must be an associative array containing the positions:
     * ----------------------------- REQUIRED PARAMS ----------------------------------
     * ['USER'] => ['ID']
     *          => ['IS_ACTIVE']
     *          => ['ORGANIZATION_ID']
     *          => ['PASSWORD_MD5'] OR ['PASSWORD_CRYPTO_PLUS']
     *          => ['NAME']
     *          => ['EMAIL']
     *
     * ['ORGANIZATION'] => ['TRADING_NAME']
     *                  => ['COMPANY_NAME']
     *
     * ['ACCESS_PROFILE'] => array(0 => ['ID']
     *                             1 => ['ID']
     *                             3 => ['ID']
     *                             ...)
     *
     * ['PASSWORD_PARAMETERS'] => ['USES_ACTIVE_DIRECTORY']
     *                         => ['IDENTIFICATION']
     *                         => ['PASSWORD_EXPIRATION_DAYS']
     *                         => ['USES_PASSWORD_CONTROL']
     *                         => ['UPDATE_DATE']
     *
     * -------------------------- OPTIONAL PARAMS ------------------------------------
     * ['IP_RESTRICTION'] => ['USES_IP_RESTRICTION']
     *                    => ['IPV4']
     *                    => ['IPV6']
     *
     * There may be a position containing extra information that will be returned by login:
     * ['OTHER_SESSION_VALUES'] => ['KEY_ONE']
     *                          => ['KEY_TWO']
     *                          => ['KEY_THREE']
     *                          => ...
     */
    public function getUserData($user, $password);

    /**
     * @param $email
     * @param $password
     * @param $identification
     *
     * Update user password, also considering the Active Directory
     */
    public function updatePassword($email, $password, $identification);

    /**
     * @param $user
     * @param $password
     * @return array
     *
     * Validate the current session of user
     *
     * The return must be an array[0] => true OR false
     */
    public function validateUser($user, $password);
}