<?php

namespace Teknisa\Libs\Util\Repositories;

use Teknisa\Libs\Util\InstanceProvider;
use Teknisa\Libs\Util\Utilities;

class LogAcesso
{
    public function create($cdoperador, $dssistema, $nrorg)
    {
        $dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';
        $query = <<<SQL
            INSERT INTO LOGACESSO
                        (CDOPERADOR, DTHRACESSO, DSSISTEMA, NRORG, DTINCLUSAO, DTULTATU, NRORGINCLUSAO, CDOPERINCLUSAO, NRORGULTATU, CDOPERULTATU)
                 VALUES (:CDOPERADOR, TO_DATE(:NOW,'$dateTimeFormat'), :DSSISTEMA, :NRORG, TO_DATE(:NOW,'$dateTimeFormat'), TO_DATE(:NOW,'$dateTimeFormat'), :NRORGINCLUSAO, :CDOPERINCLUSAO, :NRORGULTATU, :CDOPERULTATU)
SQL;
        $params = array(
            "CDOPERADOR" => $cdoperador,
            "DSSISTEMA" => $dssistema,
            "NRORG" => $nrorg,
            "NRORGINCLUSAO" => $nrorg,
            "CDOPERINCLUSAO" => $cdoperador,
            "NRORGULTATU"  => $nrorg,
            "NOW" => Utilities::getCurrentDateTimeString(),
            "CDOPERULTATU" => $cdoperador
        );
        InstanceProvider::getEntityManager()->getConnection()->executeQuery($query, $params);
    }

    public function findByOperator($cdoperador, $nrorg)
    {
        $query = <<<SQL
                  SELECT L.CDOPERADOR AS "CDOPERADOR", L.DTHRACESSO AS "DTHRACESSO", L.DSSISTEMA AS "DSSISTEMA", 
                         L.IDATIVO AS "IDATIVO", L.IDIMPLOGACESSO AS "IDIMPLOGACESSO"
                    FROM LOGACESSO L
                   WHERE L.NRORG = :NRORG
                     AND L.CDOPERADOR = :CDOPERADOR
SQL;

        $params = array(
            'NRORG' => $nrorg, 
            'CDOPERADOR' => $cdoperador
        );
        
        $data = InstanceProvider::getEntityManager()->getConnection()->fetchAllAssociative($query, $params);
        return empty($data) ? $data : $data[0];
    }

    public function update($cdoperador, $nrorg)
    {
        $dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';
        $query = <<<SQL
                  UPDATE LOGACESSO
                     SET DTHRACESSO     = TO_DATE(:NOW, '$dateTimeFormat'),
                         NRORGULTATU    = :NRORG,
                         DTULTATU       = TO_DATE(:NOW, '$dateTimeFormat'),
                         CDOPERULTATU   = :CDOPERADOR
                   WHERE CDOPERADOR     = :CDOPERADOR
                     AND NRORG          = :NRORG
SQL;

        $params = array(
            'CDOPERADOR' => $cdoperador,
            'NOW'        => Utilities::getCurrentDateTimeString(),
            'NRORG' => $nrorg
        );
        InstanceProvider::getEntityManager()->getConnection()->executeQuery($query, $params);
    }

    public function updateDtUltAcesOper($cdoperador, $nrorg)
    {
        $dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';
        $query = <<<SQL
                  UPDATE OPERADOR
                     SET DTULTACESOPER = TO_DATE(:NOW, '$dateTimeFormat')
                   WHERE CDOPERADOR = :CDOPERADOR
                     AND NRORG = :NRORG
SQL;

        $params = array(
            'CDOPERADOR' => $cdoperador,
            "NOW"     => Utilities::getCurrentDateTimeString(),
            'NRORG' => $nrorg
        );
        return InstanceProvider::getEntityManager()->getConnection()->executeQuery($query, $params);
    }
}