<?php

namespace Teknisa\Libs\Util\Repositories;

use Teknisa\Libs\Util\InstanceProvider;
use Teknisa\Libs\Util\Utilities;

class Log
{
    public static function insertLogRegister($cdpesqitem, $dsoperacao, $idtipooper, $nmtabela, $nmresoper, $dsmetusuoper, $dsnmusuoper, $dsrdmusuoper, $dsendusuoper, $organizationId, $operatorCurrent, $productId = null)
    {
        $dateTimeFormat = 'DD/MM/YYYY HH24:MI:SS';

        if (!empty($productId)) {
            $dsmetusuoper = $dsmetusuoper . ':' . $productId;
        }

        $query = <<<SQL
            INSERT INTO LOGOPERA
                        (CDPESQITEM, NMTABELA, DTOPERACAO, NMRESPOPER, IDTIPOOPER, DSOPERACAO, DSRDMUSUOPER, DSENDUSUOPER, DSNMUSUOPER, DSMETUSUOPER, CDORESPOPER, NRORG, 
                        DTINCLUSAO, DTULTATU, NRORGINCLUSAO, CDOPERINCLUSAO, NRORGULTATU, CDOPERULTATU, IDATIVO)
                 VALUES (:CDPESQITEM, :NMTABELA, TO_DATE(:NOW,'$dateTimeFormat'), :NMRESPOPER, :IDTIPOOPER, :DSOPERACAO, :DSRDMUSUOPER, :DSENDUSUOPER, :DSNMUSUOPER, :DSMETUSUOPER, :CDORESPOPER, :NRORG, 
                        TO_DATE(:NOW,'$dateTimeFormat'), TO_DATE(:NOW,'$dateTimeFormat'), :NRORGINCLUSAO, :CDOPERINCLUSAO, :NRORGULTATU, :CDOPERULTATU, :IDATIVO)
SQL;
        $params = array(
            "CDPESQITEM" => $cdpesqitem,
            "NMTABELA" => $nmtabela,
            "NMRESPOPER" => $nmresoper,
            "IDTIPOOPER" => $idtipooper,
            "DSOPERACAO"  => $dsoperacao,
            "DSRDMUSUOPER" => $dsrdmusuoper,
            "DSENDUSUOPER" => $dsendusuoper,
            "DSNMUSUOPER" => $dsnmusuoper,
            "DSMETUSUOPER" => $dsmetusuoper,
            "CDORESPOPER" => $operatorCurrent,
            "NRORG" => $organizationId,
            "NOW" => Utilities::getCurrentDateTimeString(),
            "NRORGINCLUSAO" => $organizationId,
            "CDOPERINCLUSAO" => $operatorCurrent,
            "NRORGULTATU" => $organizationId,
            "CDOPERULTATU" => $operatorCurrent,
            "IDATIVO"        => 'S',
        );
        InstanceProvider::getEntityManager()->getConnection()->executeQuery($query, $params);
    }

    public function findNmResOper($operatorCurrent, $organizationId)
    {
        $query = "SELECT CDOPERADOR, NMOPERADOR 
                    FROM OPERADOR
                   WHERE CDOPERADOR = :CDOPERADOR
                     AND NRORG = :NRORG";

        $params = array (
            "CDOPERADOR" => $operatorCurrent,
            "NRORG" => $organizationId,
        );

        return Utilities::getEntityManager()->getConnection()->fetchAllAssociative($query, $params);
    }
}