<?php
namespace Zeedhi\ZhuLog\Listeners;

use Zeedhi\Framework\Events\PostDispatch\Listener;
use Zeedhi\Framework\HTTP\Kernel;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\ZhuLog\Logger\Logger;

class BeforeResponse extends Listener {

    /** @var Logger $logger The logger object. */
    protected $logger;
    /** @var Kernel $kernel The kernel object. */
    protected $kernel;

    /**
     * Constructor...
     *
     * @param Logger $logger The logger object.
     * @param Kernel $kernel The kernel object.
     */
    public function __construct(Logger $logger, Kernel $kernel){
        $this->logger = $logger;
        $this->kernel = $kernel;
    }

    /**
     * {@inheritdoc}
     */
    public function postDispatch(Request $request, Response $response){
        $statusCode = $this->kernel->getStatusCode($response);
        $content = $this->kernel->getResponseContent($response);
        $this->logger->logResponse($statusCode, $content);
    }
}