<?php
namespace Zeedhi\ZhuLog\Logger\Persistence;

interface PersistenceInterface {

    /**
     * logRequest
     *
     * @param  string $method           Request method
     * @param  string $route            Request route
     * @param  string|null $requestType      Request type
     * @param  string $content          Request data
     * @param  string $userId           User associated data
     * @param  string $organizationId   User associated data
     * @param  string|null $productId        User associated data
     * @param  string|null $containerName    Context associetad data
     * @param  string|null $widgetName       Context associetad data
     */
    public function logRequest(string $method, string $route, $requestType, string $content, string $userId, string $organizationId, $productId, $containeName, $widgetName);

    /**
     * logResponse
     *
     * @param  int    $httpResponseCode
     * @param  string $content          Response
     */
    public function logResponse(int $httpResponseCode, string $content);

    /**
     * logException
     *
     * @param  string $method           Request method
     * @param  string $route            Request route
     * @param  string|null $requestType      Request type
     * @param  string $content          Request data
     * @param  string $userId           User associated data
     * @param  string $organizationId   User associated data
     * @param  string|null $productId        User associated data
     * @param  string|null $containerName    Context associetad data
     * @param  string|null $widgetName       Context associetad data
     */
    public function logException(string $method, string $route, $requestType, string $content, string $userId, string $organizationId, $productId, $containeName, $widgetName);
}