<?php
namespace Teknisa\PebLibs\Controllers;

use Teknisa\PebLibs\Controllers\TeknisaCrud;
use Zeedhi\Framework\DTO\Request\Filter;
use Zeedhi\Framework\DTO\Request\Row;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Framework\DataSource\FilterCriteria;
use Zeedhi\Framework\DataSource\DataSet;
use Teknisa\PebLibs\Services\InfComplService;

class Lib00206InfComplController extends TeknisaCrud{

    protected $crudService;
    protected $parameterBag;
    protected $service;
    
    public function __construct($crudService,$parameterBag,InfComplService $service) {
        parent::__construct($crudService,$parameterBag);
        $this->service = $service;
    }
    
    public function prxLote(Filter $request,Response $response){
        $filter = $request->getFilterCriteria()->getConditions();
        $params = array();
        foreach ($filter as $field) {
            $params[$field['columnName']] = $field['value'];
        }
        $cdFiliMovi = $params['CDFILIAL'];
        $dtValiLote = $params['DTVALILTE'];
        $cdProdEsto = $params['CDPRODUTO'];
        $nrLoteEstoque = $this->service->executaProcedurePrxLoteProdEst($cdFiliMovi,$dtValiLote,$cdProdEsto);
        $response->addDataSet(new DataSet('prox_lote',array('NRLOTEESTQ'=>$nrLoteEstoque)));

    }
    
    public function saveLote(Row $request,Response $response){
        $row = $request->getRow();
        
        $cdfilial = $row['CDFILIMOVI'];  
        $nrloteestq = $row['NRLOTEESTQ'];
        $nrsublote = $row['NRSUBLOTE'];
        $cdproduto = $row['CDPRODESTO'];
        $dtvalilote = $row['DTVALILOTE'];
        $dtfabrprod = $row['DTFABRPROD'];
        // TODO Implementação futura
        // $nrloteforn = $row['NRLOTEFORN'];
        // $vrtemprecebprod = $row['VRTEMPRECEBPROD'];
        // $cdfabric = $row['CDFABRIC'];
        // $cdmarcaprod = $row['CDMARCAPROD'];
        $nrloteforn = null;
        $vrtemprecebprod = 0;
        $cdfabric = null;
        $cdmarcaprod = null;

        $vrfatoconv = $row['VRFATOCONV'];
        $vrratio = $row['VRRATIO'];

        $this->service->saveLote($cdfilial,$nrloteestq,$nrsublote,$cdproduto,$dtvalilote,$dtfabrprod,$nrloteforn,$vrtemprecebprod,$cdfabric,$cdmarcaprod,$vrfatoconv, $vrratio);
    }
}