<?php
namespace Teknisa\PebLibs\Controllers;

use Zeedhi\Framework\DataSource\ParameterBag;
use Zeedhi\Framework\DTO;
use Zeedhi\Framework\DTO\Response\Error;
use Zeedhi\Framework\DataSource\DataSet;

class TeknisaCrudTotal extends TeknisaCrud {

    const DATABASE_NAME = 'dbname';

	protected $crudService;
	protected $dataSourceName;
	protected $dataSourceNameToSave  = false;
    /** @var ParameterBag */ 
    protected $parameterBag;
    /** @var string[] */
    protected $parameterBagColumns = array();
	protected $environment;
	protected $service;

    public function __construct($crudService, $parameterBag, $environment, $service) {
		$this->crudService  = $crudService;
        $this->parameterBag = $parameterBag;
        $this->environment  = $environment;
        $this->service		= $service;
 	}

	public function find(DTO\Request\Filter $request, DTO\Response $response) {
	    
        try {
            $this->dataSourceName = ($this->dataSourceName) ? $this->dataSourceName : $request->getParameter(self::DATABASE_NAME);
            $filterCriteria = $request->getFilterCriteria();
            // if(!$filterCriteria->getPage()){
            //     $filterCriteria->setPage(-1);
            //     $filterCriteria->setPageSize(-1);
            // }
             if(!$filterCriteria->getPage() && !empty($expressions)){
                $filterCriteria->setPage(-1);
                $filterCriteria->setPageSize(-1);
            }
            $filterCriteria->setDataSourceName($this->dataSourceName);
            $filterCriteria = $this->crudService->getFilterCriteriaWithNrOrg($filterCriteria);
            $newFilterCriteria = $this->crudService->getPopulatedFilterCriteria($filterCriteria, array());

            $this->crudService->find($response, $newFilterCriteria);
            
            $parameters  = $request->getParameters();
            
            $expressions = array();
            $expressions = (isset($parameters["expressions"])) ? $parameters["expressions"] : array();
       
            $lastResultExpression = array();
            $lastResultExpression = (isset($parameters["lastResultExpression"])) ? $parameters["lastResultExpression"] : array();

            if(!empty($expressions)) {
            	
            	if(!empty($expressions["expressions"])) {
                	$conditions  = $filterCriteria->getConditions(); 
                	$parameters = $request->getParameters();
                    
                    $rows = $response->getDataSets()[0]->getRows();
                    
                    $dataSourceName = $response->getDataSets()[0]->getDataSourceName();
                    if(empty($lastResultExpression)) {
                        $others = $this->service->getRowsToExpression($rows, $expressions, $filterCriteria, $this->dataSourceName, $this->environment->getNrOrgTrab());
                    }
                    else {
                        $others = $this->service->calculateOthersByOldResults($rows, $expressions, $filterCriteria, $this->dataSourceName, $lastResultExpression, $this->environment->getNrOrgTrab());
                    }
                    $rows = array_merge($rows, $others);
                    $dataSet = new DataSet($dataSourceName, $rows);
                    $others  = new DataSet("totals", $others);
                    $response->setDataSets(array($dataSet, $others));
            	}

            }

            
        } catch (\Exception $e) {
            $response->setError(new Error($e->getMessage(), 500));
        }
    }
}