<?php

namespace Teknisa\PebLibs\Services;

use \Doctrine\ORM\EntityManager;
use \Zeedhi\Framework\DB\StoredProcedure\Param;
use \Zeedhi\Framework\DB\StoredProcedure\StoredProcedure;

class InfComplService {

    protected $entityManager;

    public function __construct (EntityManager $entityManager) { 
        $this->entityManager = $entityManager;
    }
    
    public function executaProcedurePrxLoteProdEst($cdFiliMovi,$dtValiLote,$cdProdEsto) {
        
        $procedure = new StoredProcedure($this->entityManager->getConnection(), 'PRXLOTEPRODEST');
        $procedure->addParam(new Param('P_CDFILIAL', Param::PARAM_INPUT, $cdFiliMovi, Param::PARAM_TYPE_STR));
        $procedure->addParam(new Param('P_DTVALILOTE', Param::PARAM_INPUT, $dtValiLote, Param::PARAM_TYPE_STR));
        $procedure->addParam(new Param('P_CDPRODUTO', Param::PARAM_INPUT, $cdProdEsto, Param::PARAM_TYPE_STR));
        $procedure->addParam(new Param('P_RESULT', Param::PARAM_OUTPUT, null, Param::PARAM_TYPE_STR, 20));
        $nrLoteEstoq = $procedure->execute();
        $nrLoteEstoq = $nrLoteEstoq['P_RESULT'];
        
        return $nrLoteEstoq;
    }
    
    public function executaProcedurePrxLoteProdEstLoop(&$arrProdutos) {
        $count = 0;
        foreach($arrProdutos as $key => &$row){
            $cdFiliMovi = $row['cdFiliMovi'];
            $dtValiLote = $row['dtValiLote'];
            $cdProdEsto = $row['cdProdEsto'];
            $procedure = new StoredProcedure($this->entityManager->getConnection(), 'PRXLOTEPRODEST');
            $procedure->addParam(new Param('P_CDFILIAL', Param::PARAM_INPUT, $cdFiliMovi, Param::PARAM_TYPE_STR));
            $procedure->addParam(new Param('P_DTVALILOTE', Param::PARAM_INPUT, $dtValiLote, Param::PARAM_TYPE_STR));
            $procedure->addParam(new Param('P_CDPRODUTO', Param::PARAM_INPUT, $cdProdEsto, Param::PARAM_TYPE_STR));
            $procedure->addParam(new Param('P_RESULT', Param::PARAM_OUTPUT, null, Param::PARAM_TYPE_STR, 20));
            $nrLoteEstoq = $procedure->execute();
            $nrLoteEstoq = $nrLoteEstoq['P_RESULT'];
            $this->entityManager->getConnection()->close();
            
            return $nrLoteEstoq;
            
            
        }
        
    }
    
    public function saveLote($cdfilial,$nrloteestq,$nrsublote,$cdproduto,$dtvalilote,$dtfabrprod,$nrloteforn,$vrtemprecebprod,$cdfabric,$cdmarcaprod,$vrfatoconv, $vrratio) {
        $connection = $this->entityManager->getConnection();
        $sql = "INSERT INTO LOTE
                    (CDFILIAL, NRLOTEESTQ, NRSUBLOTE, CDPRODUTO, IDSTATLOTE, DTENTRLOTE, DTVALILOTE, DTFABRPROD, NRLOTEFORN, VRTEMPRECEBPROD,CDFABRIC, CDMARCAPROD, VRFATOCONV, VRRATIO)
                    (SELECT :P_CDFILIAL CDFILIAL, :P_NRLOTEESTQ NRLOTEESTQ, :P_NRSUBLOTE NRSUBLOTE,
                            :P_CDPRODUTO CDPRODUTO, 'L' IDSTATLOTE, SYSDATE DTENTRLOTE,
                            :P_DTVALILOTE DTVALILOTE, :P_DTFABRPROD DTFABRPROD,:P_NRLOTEFORN NRLOTEFORN, ROUND(:P_VRTEMPRECEBPROD, 2) VRTEMPRECEBPROD, :P_CDFABRIC CDFABRIC, :P_CDMARCAPROD CDMARCAPROD,
                            :P_VRFATOCONV, :P_VRRATIO
                       FROM PARAMGERAL
                     MINUS
                     SELECT CDFILIAL, NRLOTEESTQ, NRSUBLOTE, CDPRODUTO, 'L' IDSTATLOTE,
                            SYSDATE DTENTRLOTE, :P_DTVALILOTE DTVALILOTE, :P_DTFABRPROD DTFABRPROD, :P_NRLOTEFORN NRLOTEFORN, ROUND(:P_VRTEMPRECEBPROD, 2) VRTEMPRECEBPROD, :P_CDFABRIC CDFABRIC, :P_CDMARCAPROD CDMARCAPROD,
                            :P_VRFATOCONV, :P_VRRATIO
                       FROM LOTE
                      WHERE  :P_CDFILIAL   =  CDFILIAL     AND
                             :P_NRLOTEESTQ =  NRLOTEESTQ   AND
                             :P_NRSUBLOTE  =  NRSUBLOTE    AND
                             :P_CDPRODUTO  =  CDPRODUTO)";
        $params = array("P_CDFILIAL"=>$cdfilial,
                        "P_NRLOTEESTQ"=>$nrloteestq,
                        "P_NRSUBLOTE"=>$nrsublote,
                        "P_CDPRODUTO"=>$cdproduto,
                        "P_DTVALILOTE"=>$dtvalilote,
                        "P_DTFABRPROD"=>$dtfabrprod,
                        "P_NRLOTEFORN"=>$nrloteforn,
                        "P_VRTEMPRECEBPROD"=>$vrtemprecebprod,
                        "P_CDFABRIC"=>$cdfabric,
                        "P_CDMARCAPROD"=>$cdmarcaprod,
                        "P_VRFATOCONV"=>$vrfatoconv,
                        "P_VRRATIO" => $vrratio);

        $query = $connection->prepare($sql);
        $query->execute($params);
        
    }
}