-- ZH_LOG:

CREATE TABLE ZH_LOG
   (
        TYPE VARCHAR2(10 BYTE) NOT NULL ENABLE,
        HTTP_RESPONSE_CODE NUMBER(10,0),
        REQ_ID VARCHAR2(30 BYTE) NOT NULL ENABLE,
        METHOD VARCHAR2(10 BYTE) NOT NULL ENABLE,
        REQUEST_TYPE VARCHAR2(20 BYTE),
        TIMESTAMP DATE NOT NULL ENABLE,
        ORGANIZATION_ID NUMBER(10,0) NOT NULL,
        USER_ID VARCHAR2(30 BYTE) NOT NULL,
        PRODUCT_ID NUMBER(10,0),
        CONTAINER_NAME VARCHAR2(200 BYTE),
        WIDGET_NAME VARCHAR2(200 BYTE),
        CONTENT CLOB NOT NULL ENABLE,
        ROUTE VARCHAR2(200 BYTE),
        CONSTRAINT ZH_LOG_REQUEST_TYPE CHECK (REQUEST_TYPE IN ('DataSet', 'Row', 'Empty')) ENABLE,
        CONSTRAINT ZH_LOG_METHOD CHECK (METHOD IN ('POST', 'GET', 'PUT', 'DELETE', 'OPTIONS')) ENABLE,
        CONSTRAINT ZH_LOG_USER_ID_FK2 FOREIGN KEY (USER_ID) REFERENCES OPERADOR(CDOPERADOR),
        CONSTRAINT ZH_LOG_ORGANIZATION_ID_FK3 FOREIGN KEY (ORGANIZATION_ID) REFERENCES ORGANIZATION(ID),
        CONSTRAINT ZH_LOG_PRODUCT_ID_FK3 FOREIGN KEY (PRODUCT_ID) REFERENCES PRODUCT(ID)
   ) SEGMENT CREATION IMMEDIATE
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "TEKNISA"
 LOB ("CONTENT") STORE AS SECUREFILE (
  TABLESPACE "TEKNISA" ENABLE STORAGE IN ROW CHUNK 8192
  NOCACHE LOGGING  NOCOMPRESS  KEEP_DUPLICATES
  STORAGE(INITIAL 106496 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;

-- IDX_ZH_LOG

  CREATE INDEX "IDX_ZH_LOG" ON "ZH_LOG" ("TIMESTAMP", "ROUTE")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "TEKNISA" ;
