<?php
namespace Zeedhi\ZhuLog\Logger\Processor;

use Zeedhi\ZhuLog\Logger\Exception;

abstract class Processor {

    /**
     * Builds the array to transform in json from the request.
     * 
     * @param array  $request
     * @param string $route
     * @param string $method
     *
     * @return array
     */
    abstract public function processRequest(array $request, string $route, string $method) : array;

    /**
     * Builds the array to transform in json from the response.
     * 
     * @param array $response
     *
     * @return array
     */
    abstract public function processResponse(array $response) : array;

     /**
     * Builds the array to transform in json from the exception.
     * 
     * @param string $message
     *
     * @return array
     */
    abstract public function processException(string $message) : array;

    /**
     * @throws Exception Skip current request.
     */
    public static function skipCurrentRequest() {
        throw Exception::skipCurrentRequest();
    }
}