<?php
namespace Teknisa\ZeedhiBundle\Remote\FileUploader;

use Symfony\Component\DependencyInjection\Reference;
use Zeedhi\Framework\DependencyInjection\InstanceManager;
use Zeedhi\Framework\Remote\cURLRequest;
use Zeedhi\Framework\Remote\FileUploader\Server;

class Factory {

    const PRODUCTION_SERVER_URL = 'https://midia.teknisa.com/index.php';
    const DEV_SERVER_URL = 'http://midiatest.teknisa.com/index.php';

    const PRE_DISPATCH_EVENT = 'preDispatchEvent';
    const FILE_UPLOADER_LISTENER = "zhFileUploaderListener";

    protected static function getHttpStrategy($url) {
        return new cURLRequest($url);
    }

    protected static function factoryServer(ApiKeyProvider $apiKeyProvider, $url) {
        return new Server(self::getHttpStrategy($url), $apiKeyProvider->getFileUploaderApiKey());
    }

    public static function factoryDevServer(ApiKeyProvider $apiKeyProvider) {
        return self::factoryServer($apiKeyProvider, self::DEV_SERVER_URL);
    }

    public static function factoryProductionServer(ApiKeyProvider $apiKeyProvider) {
        return self::factoryServer($apiKeyProvider, self::PRODUCTION_SERVER_URL);
    }
    
    public static function factoryCustomServer(ApiKeyProvider $apiKeyProvider, $customUrl) {
        return self::factoryServer($apiKeyProvider, $customUrl);
    }

    public static function addListenerToPreDispatch(InstanceManager $im) {
        $preDispatchEventDefinition = $im->getContainer()->getDefinition(self::PRE_DISPATCH_EVENT);
        $preDispatchEventDefinition->addMethodCall("addListener", array(new Reference(self::FILE_UPLOADER_LISTENER)));
    }
}