<?php
namespace Teknisa\ZeedhiBundle\Remote\FileUploader;

use Zeedhi\Framework\Session\Session;

class SessionAPIKeyProvider implements ApiKeyProvider{

    const FILE_UPLOADER_API_KEY = "fileUploaderApiKey";

    /** @var Session */
    protected $session;

    /**
     * SessionAPIKeyProvider constructor.
     * @param Session $session
     */
    public function __construct(Session $session) {
        $this->session = $session;
    }


    /**
     * @param string $key Store the api key in session to avoid constant access to OM remote server.
     */
    public function setFileUploaderApiKey($key) {
        $this->session->set(self::FILE_UPLOADER_API_KEY, $key);
    }

    /**
     * {@inheritdoc}
     */
    public function getFileUploaderApiKey() {
        $this->session->get(self::FILE_UPLOADER_API_KEY, "invalid_key");
    }
}