<?php
namespace Teknisa\ZeedhiBundle\Remote\FileUploader;

use Zeedhi\Framework\Session\Session;

class StaticApiKeyProvider implements ApiKeyProvider {

    const ORGANIZATION_ID = 'nrorg';

    protected $apiKeyMapping = array(
        "ORGANIZATION_ID" => "FILE_SERVER_API_KEY"
    );

    /** @var Session */
    protected $session;

    /**
     * StaticApiKeyProvider constructor.
     * @param Session $session
     * @param array   $apiKeyMapping
     * @param string  $sessionProperty
     */
    public function __construct(Session $session, array $apiKeyMapping, $sessionProperty = self::ORGANIZATION_ID) {
        $this->session = $session;
        $this->apiKeyMapping = $apiKeyMapping;
        $this->sessionProperty = $sessionProperty;
    }


    public function getFileUploaderApiKey() {
        $apiKey = null;
        $currOrgId = $this->session->get($this->sessionProperty);
        if(isset($this->apiKeyMapping[$currOrgId])) {
            $apiKey =  $this->apiKeyMapping[$currOrgId];
        }

        return $apiKey;
    }
}