<?php
namespace Zeedhi\DataExporter\Controller;

use Zeedhi\Framework\Controller\Simple;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Request\Row;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\DataExporter\Service\ReportReader as ReportService;
use Zeedhi\DataExporter\Utility\ReportInfoManager;


/**
 * The main controller on the webservice.
 */
class ReportReader extends Simple{

    /** @var ReportService $reportService Service to build reports.*/
    protected $reportService;
    protected $reportInfoManager;

    public function __construct(ReportService $reportService, ReportInfoManager $reportInfoManager){
        $this->reportService = $reportService;
        $this->reportInfoManager = $reportInfoManager;
    }

    public function getKey($request){
        $row = $request->getDataSet()->getRows();
        $row = $row[0];
        return $row['ID'];
    }

    /**
     * Reads the report.
     *
     * Reads the report from the request.
     *
     * @param Request $request The request with the report.
     */
    public function readReport($request) {
        $row = $request->getRow();
        $report = isset($row['ROW_BASE']) ? json_decode(base64_decode($row['ROW_BASE']),true) : null;
        if(!$report){
            $key = isset($row['KEY']) ? $row['KEY'] : null;
            $report = $this->reportInfoManager->getReportInfo($key);
        }

        if(is_null($report)){
            throw new \Exception("Report not found.");
        }
        $this->reportService->printReport($report['fileName'], $report['title']);

        $this->reportService->deleteReport($report['fileName']);
        exit();
    }

}
