<?php
namespace Zeedhi\DataExporter\Service;

/**
*   Make everything that is necessary to generate the CSV file.
*/
class CSVService {
    /** @var $reportPath The path to the report. */
    protected $reportPath;

    protected $numberFormats = array(
        "currency" => true,
        "float" => true,
        "number" => true,
        "metric" => true,
        "percent" => true
    );
    
    /**
     * Constructor.
     *
     * @param $reportPath
     *
     */
    public function __construct($reportPath = null) {
        $this->reportPath = $reportPath ?: realpath("/tmp\/");
    }
    
    /**
     * Generates the report.
     *
     * @param $reportMetaData The meta data to build the report.
     * @param $reportDataSet The meta data to the report.
     */
    public function generateCSV($reportDataSet, $reportMetaData) {
        $reportName = uniqid() . ".csv";
        $reportName = str_replace(' ', '', $reportName);
        
        $targetFile = $this->reportPath . "/" . $reportName;
        $columns = $reportMetaData['columns'];        
        $this->formatByPrecisions($reportDataSet, $reportMetaData, $columns);
        
        $handle = fopen($targetFile, "w");
        foreach ($reportDataSet as $line) {
            if(is_array($line)) {
                foreach ($line as $idx => $column) {
                    if(is_array($column)) {
                        $line[$idx] = !empty($column[0]) ? $column[0] : '';
                    }
                }
            }
            fputcsv($handle, $line);
            fseek($handle, -1, SEEK_CUR);
            fwrite($handle,";\n");
        }
        fclose($handle);
        
        return $targetFile;
    }

    private function formatByPrecisions(&$gridData, $metaData, $columns){
        $precisions = $this->extractPrecisions($columns, $gridData[0]);
        for($i=1; $i < count($gridData); $i++){
            foreach($precisions as $key => $precision){
                $gridData[$i][$key] = round($gridData[$i][$key], $precision);
            }
        }
    }

    private function extractPrecisions($columns, $fieldNames){
        $precisions = array();
        foreach($columns as $columnName => $column){
            if($this->columnHasNumberFormat($column)){
                $columnFormat = $column['format'];
                $precision = 2;
                if(isset($columnFormat['params']) && !empty($columnFormat['params']['precision'])){
                    $precision = $columnFormat['params']['precision'];
                }
                $precisions[array_search($columnName, $fieldNames)] = $precision;
            }
        }
        return $precisions;
    }

    private function columnHasNumberFormat($column){
        $hasNumberFormat = false;
        if (isset($column['format'])){
            $formatType = $column['format']['type'];
            $hasNumberFormat = isset($this->numberFormats[$formatType]) && $this->numberFormats[$formatType];
        }
        return $hasNumberFormat;
    }
}