<?php
namespace Zeedhi\DataExporter\Service;


/**
 * Interface ExportsStrategy.
 *
 * Provides the strategy to export the file, wich is: start, writeRows and finish.
 */
interface ExportStrategy {

    /**
     * Does the necessary to make possible to write on the file the necessary data.
     *
     * Start the exporting, by doing what is necessary to generate the report. Mainly
     * creating the file, builind the very fist structure based on the given metadata, getting the
     * datasource data, and writing its header.
     *
     * @param  array  $metadata Definition the structure of the report.
     */
    public function start(array $metadata);

    /**
     * Write the given rows on the created file.
     *
     * Treats the row to be written on the file and write them on it.
     *
     * @param  array  $rows Rows to be written on the file.
     */
    public function writeRows(array $rows);

    /**
     * Finishes the export.
     *
     * Finishes the export by writing the bottom of the file and returning the name of the generated
     * file
     *
     * @return string The name of the generated report.
     */
    public function finish();

    /**
     * Get the format in wich the file will be generated by using this export strategy.
     *
     * @return string The format of the report generated with this strategy.
     */
    public function formatName();
}