<?php
namespace Zeedhi\DataExporter\Service\SpreadSheet;


/**
 * The xls writer.
 */
class XLSXWriter implements SpreadsheetWriter {

    protected static $ALFA_MUNERIC = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';

    /** @var $reportDirectory string The directory of the report. */
    protected $reportDirectory;

    /**
     * Constructor.
     *
     * @param $reportDirectory String The directory of the report.
     */
    function __construct($reportDirectory){
        $this->reportDirectory = $reportDirectory;
    }

    protected static function getIndexColumm($columnLetter){
        $length = strlen($columnLetter);
        $thisWordCodeVerdeeld = 0;
        for ($i=0; $i<$length; $i++) {
            $thisWordCodeVerdeeld += strrpos(self::$ALFA_MUNERIC,$columnLetter[$i]);
        }
        return $thisWordCodeVerdeeld;
    }

    public function markMergedCellByMetaData(\XLSXWriter $writer,$metaData){
        $sheet_name =  'Sheet1' ;
        if(!empty($metaData['xlsMergedCell'])){
            foreach ( $metaData['xlsMergedCell'] as $xlsMergedCell) {
                $start_row = intval($xlsMergedCell['start_row'])-1;
                $start_col = self::getIndexColumm($xlsMergedCell['start_col']);
                $end_row = intval($xlsMergedCell['end_row'])-1;;
                $end_col = self::getIndexColumm($xlsMergedCell['end_col']);
                $writer->markMergedCell($sheet_name, $start_row, $start_col, $end_row, $end_col);
            }
        }
    }

    public function getIndexRowTotal($metaData, $gridData){
        $indexRowTotal = array();
        $indexColumnTotal = array();
        if(!empty($metaData['xlsMergedCell'])){
            $indexRowTotal = array(count($gridData));
            foreach ( $metaData['xlsMergedCell'] as $xlsMergedCell) {
                $indexRowTotal[] = intval($xlsMergedCell['end_row'])-1;;
                $indexColumnTotal[] = self::getIndexColumm($xlsMergedCell['start_col']);
            }
        }
        return array($indexRowTotal,array_unique($indexColumnTotal));
    }

    /**
     * Generates the XLS.
     *
     * @param $gridData array The grid data.
     * @param $metaData array The meta data to build the report.
     *
     * @return string The generated file name.
     */
    public function generateXLS($gridData, $metaData){
        $fileName = uniqid() . ".xlsx";
        $fileName = str_replace(' ', '', $fileName);

        $columns = $metaData['columns'];
        $writer = new \XLSXWriter();
        $header = $this->getHeader($gridData[0], $columns);

        if(!empty($header)){
            unset($gridData[0]);
            list($indexRowTotal,$indexColumnTotal) = $this->getIndexRowTotal($metaData,$gridData);
            $this->writeSheetCustom($writer,$gridData, '', $header,$indexRowTotal,$indexColumnTotal);
        }
        else{
            $gridData[0] = array_map(
                function($column) use ($columns){
                    return isset($columns[$column]['description']) ? $columns[$column]['description'] : "";
                },
                $gridData[0]
            );
            $writer->writeSheet($gridData);
        }
       // $this->markMergedCellByMetaData($writer,$metaData);
        $finalName = $this->reportDirectory."/".$fileName;

        $writer->writeToFile($finalName);

        return $finalName;
    }

    public function writeSheetCustom(\XLSXWriter $writer, array $data, $sheet_name = '', array $header_types = array(),
                                     $indexRowTotal = array(),$indexColumnTotal = array())
    {
        $sheet_name = empty($sheet_name) ? 'Sheet1' : $sheet_name;
        $data = empty($data) ? array(array('')) : $data;
        $stylesTotal = array('font-style' => 'bold', 'fill' => '#eee', 'border' => 'left,right,top,bottom', 'auto_filter' => true);
        $styleColumn = $this->getStyleColumn($header_types, $indexColumnTotal, $stylesTotal);
        if (!empty($header_types))
        {
            $writer->writeSheetHeader($sheet_name, $header_types,$stylesTotal);
        }
        foreach($data as $i=>$row)
        {
            if(in_array($i, $indexRowTotal)){
                $writer->writeSheetRow($sheet_name, $row,$stylesTotal);
            }else{
                $writer->writeSheetRow($sheet_name, $row,$styleColumn);
            }

        }
    }

    public function getStyleColumn($header_types, $indexColumnTotal, $stylesTotal){
        $styles = array();
        $maxColumnGroup = count($indexColumnTotal);
        foreach ($header_types as $index => $header_type) {
            if($maxColumnGroup > count($styles)){
                $styles[] =  $stylesTotal;
            }else{
                $styles[] =  null;
            }
        }
        return $styles;
    }


    /**
     * Retrieves the header from the metada data.
     *
     * @param $columnsName array Index columns
     * @param $columns array The grid columns.
     *
     * @return array The generated file name.
     */
    private function getHeader(array $columnsName, array $columns){
        $columnsName = array_map(
            function($column) use ($columns){
                return isset($columns[$column]['description']) ? $columns[$column]['description'] : "";
            },
            $columnsName
        );
        $preparedHeader = [];
        foreach ($columnsName as $columnName) {
            $preparedHeader[$columnName] = 'GENERAL';
        }

        foreach ($columns as $key => $column){
            if(!empty($column['xlsType']) && !empty($column['description']) && !empty($preparedHeader[$column['description']])){
                $preparedHeader[$column['description']] = $column['xlsType'];
            }
        }
        return $preparedHeader;
    }
}
