<?php
namespace Zeedhi\DataExporter\Utility;

class UniqueFileNameProviderTest extends \PHPUnit_Framework_TestCase {

    public function testGenerateFileName() {
        $fileNameGenerator = new UniqueFileNameProvider("folderPath");
        $fileName = $fileNameGenerator->generateFileName("csv");
        $this->assertRegExp("/[0-9a-z]{13}\.csv/", $fileName);
    }

    public function testGetFullFilePath() {
        $fileNameGenerator = new UniqueFileNameProvider("folderPath");
        $fileName = $fileNameGenerator->generateFileName("csv");
        $fullFilePath = $fileNameGenerator->getFullFilePath($fileName);
        $this->assertEquals("folderPath". DIRECTORY_SEPARATOR . $fileName, $fullFilePath);
    }

}
