<?php
namespace Zeedhi\DataExporter\Service\DataProvider;

use Zeedhi\DataExporter\Service\DataProvider;
use Zeedhi\DataExporter\Exception\Exception;
use Zeedhi\Framework\DataSource\FilterCriteria;
use Zeedhi\Framework\DataSource\Manager;

/**
 * Manages the datasource, treting errors on the fetch.
 */
class DataSourceManager implements DataProvider{

    /** @var Manager Manager to implements the fetch function. */
    private $dataSourceManager;
    /** @var FilterCriteria Filter base to get the value. */
    private $filterCriteria;

    /** @var currentFilterCriteria Current filter base to get the value.*/
    private $currentFilterCriteriaPage = 0;

    /**
     * Constructor.
     *
     * @param Manager $dataSourceManager
     */
    public function __construct(Manager $dataSourceManager)
    {
        $this->dataSourceManager = $dataSourceManager;
    }

    /**
     * Init Data provider.
     *
     * @param  FilterCriteria $filterCriteria   Filter base to get the value.
     *
     */
    public function start(FilterCriteria $filterCriteria)
    {
        $this->filterCriteria = $filterCriteria;
    }

    /**
     * Find the value using the given filterCriteria.
     *
     * Try to find the the values that match with the given filterCriteria and returns it.
     *
     * @return array Rows that maches the given filter.
     *
     * @throws Exception If there is some erro while fetching data
     */
    public function fetch()
    {
        try {
            $this->currentFilterCriteriaPage++;
            $this->filterCriteria->setPage($this->currentFilterCriteriaPage);
            $dataSet = $this->dataSourceManager->findBy($this->filterCriteria);
            return $dataSet->getRows();
        } catch (\Exception $e) {
            throw Exception::exceptionWhileFetchingData($e);
        }
    }

    /**
     * Clean connection
     */
    public function finish()
    {
        $this->filterCriteria = null;
        $this->currentFilterCriteriaPage = 0;
    }
}