<?php

namespace Zeedhi\DataExporter\Utility;

/**
 * Manages the name and path of the files that will be created.
 */
class UniqueFileNameProvider {

    /** @var string Path to the file folder. */
    private $folderPath;

    /**
     * Constructor.
     *
     * @param string $folderPath
     */
    public function __construct($folderPath) {
        $this->folderPath = $folderPath;
    }

    /**
     * Generate the file name.
     *
     * Generate a unique file name by using uniqid plus the extension.
     *
     * @param  string $extension    The file extention.
     * @param  string $filePrefix   The report name 
     *
     * @return string The file name.
     */
    public function generateFileName($extension) {
        return uniqid() . "." . $extension;
    }

    /**
     * Retrives the full path of the file.
     *
     * Uses the file name plus the folderPath to get the full path of the file.
     *
     * @param  string $fileName   Name of the file to get the full path of it.
     *
     * @return string The full path of the given file.
     */
    public function getFullFilePath($fileName) {
        return $this->folderPath . DIRECTORY_SEPARATOR . $fileName;
    }
}