<?php
namespace Zeedhi\DataExporter\Service;

use Zeedhi\DataExporter\Service\DataHandler\StaticData;

class StaticDataTest extends \PHPUnit_Framework_TestCase {

    /** @var array $staticData */
    protected $staticData;
    /** @var array $decodedRows */
    protected $decodedRows;

    public function setUp(){
        $this->decodedRows = array(
            array(
                "REGION_ID" => "Americas",
                "CITY" => "Belo Horizonte",
                "COUNTRY" => "Brazil",
            ),
            array(
                "REGION_ID" => "Europe",
                "CITY" => "Paris",
                "COUNTRY" => "French",
            ),
        );
    }

    public function testDecodeRows(){
        $rows = array(
            array(
                "REGION_ID" => 2,
                "CITY" => "Belo Horizonte",
                "COUNTRY" => "Brazil",
            ),
            array(
                "REGION_ID" => 1,
                "CITY" => "Paris",
                "COUNTRY" => "French",
            ),
        );
        $staticData = array(
            "REGION_ID" => array(1 => "Europe", 2 => "Americas", 3 => "Middle East and Africa", 4 => "Asia"),
        );

        $staticDataClass = new StaticData();
        $responseRows = $staticDataClass->decodeRows($rows, $staticData);
        $decodedRows = $this->decodedRows;
        $this->assertEquals($responseRows, $decodedRows, "", 0.0, 10, true, true);
    }

    public function testOrderData(){
        $rows = [
            ["EMPLOYEE_ID" => 1, "FIRST_NAME" => "Haddad"],
            ["EMPLOYEE_ID" => 2, "FIRST_NAME" => "Mateus"],
            ["EMPLOYEE_ID" => 3, "FIRST_NAME" => "Starling"],
            ["EMPLOYEE_ID" => 4, "FIRST_NAME" => null]
        ];

        $orderBy = [
            ["name"=>"FIRST_NAME", "direction"=>"DESC"]
        ];

        $staticDataClass = new StaticData();
        $responseRows = $staticDataClass->orderData($orderBy, $rows);
        $orderedData = array_reverse($rows);
        $this->assertEquals($orderedData, $responseRows);

        $orderBy[0]["direction"] = "ASC";

        $responseRows = $staticDataClass->orderData($orderBy, $rows);
        $this->assertEquals($rows, $responseRows);
    }
}
