# Zeedhi Report Local
Zeedhi Report Local is an project that create files as a data dump. It allows the integration between your project and most of external projects.
It will create a output file for your dataSources, which can be downloaded.


## Installation

To install the component, first you need to put the dependency on `composer.json`:
```
"zeedhi/dataexporter": "dev-master"
```

And run `composer install`

## Configuration

To configure your dataExporter correctly you should configure your:

### Backend Environment
Here you need to configure the params passed to connect to the dataBase and to do
the first treatment of the data. To do this, go to your `backend/environment.xml`
file and configure it's params as follows:
```
<?xml version="1.0"?>
<container xmlns="http://symfony.com/schema/dic/services"
           xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
           xsi:schemaLocation="http://symfony.com/schema/dic/services http://symfony.com/schema/dic/services/services-1.0.xsd">
    <parameters>
        <parameter key="connection_params" type="collection">
            <parameter key="driver">oci8</parameter>
            <parameter key="user"><>ORACLE_USER<></parameter>
            <parameter key="password"><>ORACLE_PASSWD<></parameter>
            <parameter key="host"><>ORACLE_HOST<></parameter>
            <parameter key="port"><>ORACLE_PORT<></parameter>
            <parameter key="dbname">pdborcl</parameter>
            <parameter key="service">true</parameter>
            <parameter key="driverClass">Zeedhi\Framework\DBAL\Driver\OCI8\Driver</parameter>
        </parameter>

        <parameter key="mongoHost"><>MONGO_HOST<></parameter>
        <parameter key="mongoPort"><>MONGO_PORT<></parameter>
        <parameter key="mongoDbName"><>MONGO_DBNAME<></parameter>
        <parameter type="collection" key="mongoOptions">
            <parameter key="username"><>MONGO_USERNAME<></parameter>
            <parameter key="password"><>MONGO_PASSWD<></parameter>
            <parameter key="db"><>MONGO_DBNAME<></parameter>
            <parameter key="authSource"><>MONGO_AUTH_SOURCE<></parameter>
        </parameter>

        <parameter key="cacheHost"><>CACHE_HOST<></parameter> <!-- localhost by default -->
        <parameter key="cachePort"><>CACHE_PORT<></parameter> <!-- 11211 by default -->

        <parameter key="route_file_name">../routes.json</parameter>
        <parameter key="baseUri">service/index.php</parameter>

        <parameter key="pdf_report_assets_path"><>PDF_REPORT_ASSETS_PATH<></parameter>
    </parameters>
</container>
```

### Backend Services
Here you will configure the services that the data exporter need to work. To do
this, read `vendor/zeedhi/dataexporter/services.xml` or go to your `services.xml` and add to your services tag the services declared on
the [services example](http://code.zeedhi.com/zeedhi/zeedhi-report-samples/blob/master/backend/services.xml)
listed bellow:

- ZeedhiDataExporterDataProvider
- ZeedhiDataFileNameProvider
- ZeedhiDataExporterSpreadSheetStrategy
- ZeedhiDataExporterService
- ZeedhiExportDataController
- ZeedhiExportDataReportController

And, declare in your parameters tag one with the key `zeedhi_data_exporter_folder`
with the address where will be created your files.
The last thing to do is configure the timeout for the report generation. Declare another parameter with the key `zeedhi_data_exporter_timeout`.

Follow the [model](http://code.zeedhi.com/zeedhi/zeedhi-report-samples/blob/master/backend/services.xml)
to help.


### Frontend Environment
Next, you need to configure the
 - Report url.
 - Exporter url.
 - Destination for the exporter file url.

This configuration will be done at your `json/environment.json`.

The properties used for each one are respectively:
 - reportsUrl
 - exporterUrl
 - exporterFileDestinationUrl

You can configure based on the [deploy environment config](http://code.zeedhi.com/zeedhi/zeedhi-report-samples/tree/master/frontend/config/deploy.json).
Be careful with the address decared in your `exporterFileDestinationUrl` to it point to the same passed as
param on your `services.xml`.

## Backend Routes
To configure the route used by the dataexporter, add `zeedhi_data_exporter_route_file` to your routeParser or go to
the [routes example](http://code.zeedhi.com/zeedhi/zeedhi-report-samples/blob/master/backend/routes.json)
and declare equals to the example the ones with the uri equals to:
- `/generateXLS`
- `/generateReport`
- `/reports/{reportName}`

## Frontend Json
The last step is go to your json and add to the widget where the reports will be
generated based on the following configuration:

```
"floatingControl": {
    "xlsAction": {
        "dataSourceName": "YOUR_DATASOURCE",
        "runAt": "server"
    },
    "pdfAction": {
        "dataSourceName": "YOUR_DATASOURCE",
        "runAt": "server"
    }
}
```
## Configuring the type

To change the type of the report column on the xls you need to configure the property 'xlsDefaultType' on the json with one of the following values:

| Value | Format |
|:----|---------:|
| string| @ |
| integer | 0 |
| date | YYYY-MM-DD |
| datetime | YYYY-MM-DD HH:MM:SS |
| price | #,##0.00 |
| dollar | [$$-1009]#,##0.00;[RED]-[$$-1009]#,##0.00  |
| euro | '#,##0.00 [$€-407];[RED]-#,##0.00 [$€-407] |


To configure a column with a different type you must set the property 'xlsType'  inside the field on the json.