<?php
namespace Zeedhi\DataExporter\Service;

use Zeedhi\Framework\DataSource\FilterCriteria;

/**
 * Interface DataProvider
 *
 * Manages the data providing, by splitting it in tree main routines: start, fetch and finish.
 */
interface DataProvider {

    /**
     * Initialize the necessary values to fetch.
     *
     * @param  FilterCriteria $filterCriteria The conditions and variables necessary to the fetch.
     */
    public function start(FilterCriteria $filterCriteria);

    /**
     * Fetchs the data.
     *
     * @return array Result of the fetch.
     */
    public function fetch();

    /**
     * Finishes the routine of providing the data.
     */
    public function finish();

}