<?php

namespace Zeedhi\DataExporter\Utility;

use Zeedhi\Framework\Cache\Cache;
use Zeedhi\DataExporter\Exception\Exception;

class ReportInfoManager {

    /** @const KEY_PREFIX Prefix to save the report data on the cache. */
    const KEY_PREFIX = "DATAEXPORTER";
    /** @var Cache Caches the report info. */
    var $cache;

    /**
     * Constructor.
     *
     * @param Cache $cache Caches the report info.
     */
    public function __construct(Cache $cache, string $cacheHost, int $cachePort) {
        $this->cache = $cache;
        $this->cache->getMemcached()->addServer($cacheHost, $cachePort);
    }

    /**
     * Save the file data on the cache.
     *
     * Generate a key to save the file and returns it.
     *
     * @param string $fileName File name to be saved on the cache.
     * @return string Key of the file info.
     */
    public function save($fileName){
        $key = uniqid($this::KEY_PREFIX);
        $this->cache->save($key, $fileName);
        return $key;
    }

    /**
     * Return the info of the file with the given key.
     *
     * Return the info of the file with the given key removing it from the cache.
     *
     * @param string $key Key of the desired file info.
     *
     * @return array Report info.
     *
     * @throws Exception Throws if the $key can't be removed from Cache, means that it
     *  was not Cached.
     */
    public function getReportInfo($key){
        if ($this->cache->contains($key)) {
            $data = $this->cache->fetch($key);
            $this->cache->delete($key);
            return $data;
        } else {
            throw Exception::reportNotFound();
        }
    }

}