<?php
namespace Zeedhi\DataExporter\Service\DataHandler;

use Zeedhi\DataExporter\Service\DataHandler as AbstractHandler;

/**
 * Decode the static data coming from the metadata.
 */
class StaticData implements AbstractHandler {

    /**
     * Replaces the rows values to the values that are displayed at screen (static values).
     *
     * @param array $rows       Rows as they are at dataSource.data.
     * @param array $staticData Rows as they are at dataSource.data.
     *
     * @return array Array of modified rows to show at screen or use in report.
     */
    public function decodeRows(array $rows, array $staticData){
        foreach ($rows as $index => $row) {
            foreach ($row as $key => $id) {
                if (array_key_exists($key, $staticData)) {
                    if (is_array($id)) {
                        foreach ($id as $subId) {
                            $rows[$index][$key] = isset($staticData[$key][$subId])? $staticData[$key][$subId] : $rows[$index][$key];
                        }
                    } else ($rows[$index][$key] = isset($staticData[$key][$id])? $staticData[$key][$id] : $rows[$index][$key]);
                }
            }
        }
        return $rows;
    }
    public static function isValidDate($date, $format = 'd/m/Y H:i:s') {
        try {
            if (!is_string($date)) {
                return false; // Se não for string, já retorna falso
            }
            $d = \DateTime::createFromFormat($format, $date);
            return $d && $d->format($format) === $date;
        } catch (\Exception $e) {
            return false; // Se ocorrer qualquer erro, retorna falso
        }
    }
    /**
     * Ordenates the rows using order by clausures.
     *
     * @param array $orderBy    Order by clausure got from filter.
     * @param array $dataSet    Rows as they are at dataSource.data.
     *
     * @return array Array of modified rows to show at screen or use in report.
     */
    public function orderData(array $orderBy, array $dataSet, $metaData = []){
        $this->orderBy = $orderBy;
        $this->columns = [];
        if (!empty($metaData['columns'])) {
            $this->columns = $metaData['columns'];
        }

        usort($dataSet, function($a, $b){
            foreach ($this->orderBy as $value) {
                $datetime = false;
                if (!empty($this->columns[$value["name"]]['format']['type'])) {
                    $datetime = $this->columns[$value["name"]]['format']['type'] === 'datetime';
                }
                if(is_null($b[$value["name"]])){
                    return $value["direction"] == "ASC" ? -1 : 1;
                } else if(is_null($a[$value["name"]])){
                    return $value["direction"] == "ASC" ? 1 : -1;
                }
                if($datetime && self::isValidDate($a[$value["name"]]) && self::isValidDate($a[$value["name"]])) {
                    if($a[$value["name"]] !== $b[$value["name"]]) {
                        $dateA = \DateTime::createFromFormat('d/m/Y H:i:s', $a[$value["name"]]);
                        $dateB = \DateTime::createFromFormat('d/m/Y H:i:s', $b[$value["name"]]);
                        return ($value["direction"] == "ASC" ? $dateA <=> $dateB : $dateB <=> $dateA);
                    }
                } else {
                    if($a[$value["name"]] < $b[$value["name"]]){
                        return $value["direction"] == "ASC" ? -1 : 1;
                    }
                    if($a[$value["name"]] > $b[$value["name"]]){
                        return $value["direction"] == "ASC" ? 1 : -1;
                    }
                }
            }
            return 0;
        });
        return $dataSet;
    }

}