<?php

namespace Zeedhi\DataExporter\Service;

use Zeedhi\Framework\Controller\Simple;


class ReportReader extends Simple{


    /**
     * Constructor.
     *
     * @param $reportPath The path to the report
     */
    public function __construct($reportPath) {
        $this->reportPath = $reportPath;
    }


    /**
     * Retrieves the report path
     *
     * @param $reportName The name of the report whose path will be retrieved.
     */
    protected function getReportPath($reportName) {
        return $reportName;
    }

    /**
     * Reads the file.
     *
     * @param $reportPath The path to the report
     */
    protected function readFile($reportPath){
        readfile($reportPath);
    }

    /**
     * Configure the headers to read correctly the file.
     *
     * Set the file type and the name to be downloaded on the header.
     *
     * @param string $filePath Real name of the file that will be downloaded.
     * @param string $title Custom name of the file that will be downloaded.
     */
    protected function setHeaders($filePath, $title){
        $extension = pathinfo($filePath, PATHINFO_EXTENSION);
        header("Content-type:application/$extension");
        header("Content-Disposition:inline;filename=$title.$extension");
    }


    /**
     * Prints the report from the file.
     *
     * @param $reportName The name of the report to be printed.
     */
    public function printReport($reportName, $title) {
        $reportPath = $this->getReportPath($reportName);
        $this->setHeaders($reportName, $title);
        $this->readFile($reportPath);
    }


    /**
     * Deletes the report.
     *
     * @param $reportName The name of the report to be deleted.
     */
    public function deleteReport($reportName) {
        $reportPath = $this->getReportPath($reportName);
        unlink($reportPath);
    }


}