<?php
namespace Zeedhi\DataExporter\Service;

use Zeedhi\DataExporter\Service\DataProvider\DataSourceManager;
use Zeedhi\DataExporter\Exception\Exception;
use Zeedhi\Framework\DataSource\DataSet;
use Zeedhi\Framework\DataSource\FilterCriteria;
use Zeedhi\Framework\DataSource\Manager;

class DataSourceManagerTest extends \PHPUnit_Framework_TestCase {

    /** @var DataSourceManager */
    private $dataProvider;
    /** @var Manager|\PHPUnit_Framework_MockObject_MockObject */
    private $manager;

    public function setUp() {
        $this->manager = $this->getMockBuilder(Manager::class)->getMock();
        $this->dataProvider = new DataSourceManager($this->manager);
    }

    public function testDefaultUse() {
        $expectedRows = array(
            array("name" => "one", "value" => 1),
            array("name" => "two", "value" => 2),
            array("name" => "three", "value" => 3),
            array("name" => "four", "value" => 4),
            array("name" => "five", "value" => 5),
        );

        $filterCriteria = new FilterCriteria("dataSourceName");
        $this->dataProvider->start($filterCriteria);
        $this->manager->expects($this->once())->method("findBy")
            ->with($filterCriteria)
            ->willReturn(new DataSet("dataSourceName", $expectedRows));
        $returnedRows = $this->dataProvider->fetch();
        $this->assertEquals($expectedRows, $returnedRows);
        $this->dataProvider->finish();
    }

    public function testInternalException() {
        $this->expectException(Exception::class);
        $this->expectExceptionMessage("A exception occurred while we try to fetch the data: Previous Message");
        $this->expectExceptionCode(Exception::EXCEPTION_ON_FETCH_DATA);

        $filterCriteria = new FilterCriteria("dataSourceName");
        $this->dataProvider->start($filterCriteria);
        $previousException = new \Exception("Previous Message");
        $this->manager->expects($this->once())->method("findBy")
            ->with()
            ->willThrowException($previousException);
        $this->dataProvider->fetch();
    }
}
