<?php
namespace Zeedhi\DataExporter\Service\ExportStrategy;

use \Zeedhi\DataExporter\Service\ExportStrategy;
use \Zeedhi\DataExporter\Service\DataExporter;

class EscapedSpreadSheetTest extends \PHPUnit_Framework_TestCase {

    /** @var array */
    private $metaData;
    /** @var EscapedSpreadSheet */
    private $escapedExportStrategy;
    /** @var ExportStrategy|\PHPUnit_Framework_MockObject_MockObject */
    private $exportStrategyMock;

    protected function setUp() {
        $this->exportStrategyMock = $this->getMockBuilder(ExportStrategy::class)
            ->getMock();

        $this->escapedExportStrategy = new EscapedSpreadSheet($this->exportStrategyMock);

        $this->metaData = array(
            "columns" => array(
                "value" => array(
                    "size"        => "30%",
                    "align"       => "left",
                    "sequence"    => 2,
                    "description" => "Value"
                ),
                "name" => array(
                    "size"        => "70%",
                    "align"       => "left",
                    "sequence"    => 1,
                    "description" => "Name"
                )
            )
        );
    }

    public function testDefaultUsage() {
        $rows = array(
            array("name" => "=one", "value" => 1),
            array("name" => "two", "value" => 2),
            array("name" => "three", "value" => 3),
            array("name" => "=four", "value" => 4),
            array("name" => "five", "value" => 5),
        );

        $escapedRows = array(
            array("name" => "'=one", "value" => 1),
            array("name" => "two", "value" => 2),
            array("name" => "three", "value" => 3),
            array("name" => "'=four", "value" => 4),
            array("name" => "five", "value" => 5),
        );

        $this->exportStrategyMock->expects($this->once())
            ->method('formatName')
            ->willReturn(DataExporter::EXPORT_FORMAT_SPREADSHEET);

        $this->exportStrategyMock->expects($this->once())
            ->method('start')
            ->with($this->metaData);

        $this->exportStrategyMock->expects($this->once())
            ->method('writeRows')
            ->with($escapedRows);

        $this->exportStrategyMock->expects($this->once())
            ->method('finish');

        $this->assertEquals(DataExporter::EXPORT_FORMAT_SPREADSHEET, $this->escapedExportStrategy->formatName());
        $this->escapedExportStrategy->start($this->metaData);
        $this->escapedExportStrategy->writeRows($rows);
        $this->escapedExportStrategy->finish();
    }

    public function testDataWithEmptyStrings() {
        $rows = array(
            array("name" => "=one", "value" => 1),
            array("name" => "", "value" => 2),
            array("name" => "three", "value" => 3),
            array("name" => "=four", "value" => 4),
            array("name" => "five", "value" => 5),
        );

        $escapedRows = array(
            array("name" => "'=one", "value" => 1),
            array("name" => "", "value" => 2),
            array("name" => "three", "value" => 3),
            array("name" => "'=four", "value" => 4),
            array("name" => "five", "value" => 5),
        );

        $this->exportStrategyMock->expects($this->once())
            ->method('formatName')
            ->willReturn(DataExporter::EXPORT_FORMAT_SPREADSHEET);

        $this->exportStrategyMock->expects($this->once())
            ->method('start')
            ->with($this->metaData);

        $this->exportStrategyMock->expects($this->once())
            ->method('writeRows')
            ->with($escapedRows);

        $this->exportStrategyMock->expects($this->once())
            ->method('finish');

        $this->assertEquals(DataExporter::EXPORT_FORMAT_SPREADSHEET, $this->escapedExportStrategy->formatName());
        $this->escapedExportStrategy->start($this->metaData);
        $this->escapedExportStrategy->writeRows($rows);
        $this->escapedExportStrategy->finish();
    }
}
