# Zeedhi File Server API

The Zeedhi File Server API is a library focused on dealing with cURL and the Zeedhi Framework to work with the Zeedhi File Server.
It uses the deprecated versions of the framework and API to provide an implementation that works with PHP 5.6.

## Configuring

There's no big obstacle to configure the FileServerAPI. It's a small library that only needs some dependencies to be included on the `xml` configurations.

As follows:
```xml
<service id="HttpRequestStrategy" class="Zeedhi\Framework\Remote\cURLRequest">
    <argument>%fileServerUrl%</argument>
</service>

<service id="FileUploader" class="Zeedhi\Framework\Remote\FileUploader\Server">
    <argument type="service" id="HttpRequestStrategy"/>
    <argument>%apiKey%</argument>
</service>

<service id="FileServerAPI" class="Zeedhi\FileServerAPI\Server" parent="FileUploader"/>

<service id="RequestFactory" class="Zeedhi\Framework\Remote\RequestFactory"/>

<service id="API" class="Zeedhi\FileServerAPI\API">
    <argument id="FileServerAPI" type="service"/>
    <argument id="RequestFactory" type="service"/>
</service>
```

## How to use

It basically has all methods to talk with the File Server implemented, and is pratical and easy to use.

### Organizations

All responses are datasets.

#### Dumping the organizations list
```php
$this->api->dumpOrganizations();
```

#### Creating organizations
```php
$this->api->createOrganization([
    'name' => 'NewOrganizationName',
    'canUpload' => false
])
```

#### Deleting organizations
```php
$this->api->deleteOrganization('NewOrganizationName');
```

#### Updating organizations
```php
$this->api->updateOrganization('NewOrganizationName', [
    'apiKey' => true
]);
```

### Files

Most responses are datasets but the `downloadFile` method that retrieves the content of the file as string.

#### Download file

A good practice is to use Zeedhi's setFileToDownload to download it.
```php
$response->setFileToDownload(
    new File(
        'path', 
        false, 
        'file.jpeg', 
        'image/jpeg', 
        $this->api->downloadFile('/folder/custom/file.jpeg')
    )
);
```

But if you're using a version lower than 2.3.5 It can be done just as easy:
```php
header('Content-Disposition: attachment; filename=file.jpeg');
header('Content-Type: image/jpeg');
echo $this->api->downloadFile('/folder/custom/file.jpeg');die;
```

#### Dumping the file list
```php
$this->api->dumpFiles();
```

#### Uploading a file
```php
$this->api->uploadFile([
    'FILE' => [[
        'name' => 'test.jpeg',
        'b64File' => 'data:image/jpeg;base64,your_base64_encoded_file'
    ]],
    'FOLDER' => 'test'
]);
```

#### Uploading multiple files
```php
$this->api->uploadFiles([
    [
        'FILE' => [[
            'name' => 'test1.jpeg',
            'b64File' => 'data:image/jpeg;base64,your_base64_encoded_file'
        ]],
        'FOLDER' => 'test'
    ],
    [
        'FILE' => [[
            'name' => 'test2.jpeg',
            'b64File' => 'data:image/jpeg;base64,your_base64_encoded_file'
        ]],
        'FOLDER' => 'test'
    ]
]);
```

#### Deleting a file
```php
$this->api->deleteFile('/folder/custom/file.jpeg');
```