<?php
namespace Zeedhi\FileServerAPI;

use Zeedhi\Framework\Remote\cURLRequest;
use Zeedhi\Framework\Remote\RequestFactory;
use Zeedhi\FileServerAPI\Server;

/**
 * File Server API factory class.
 */
class Factory {
    /**
     * Create API instance
     * @param string $host   Path to fileServer in use
     * @param string $apiKey API key for current organization
     * @return static API instance
     */
    public static function factoryAPI($host, $apiKey) {
        $httpInterface = new cURLRequest($host);
        $fileServer = new Server($httpInterface, $apiKey);
        $requestFactory = new RequestFactory();

        return new API($fileServer, $requestFactory);
    }
}