<?php
namespace Zeedhi\FileServerAPI;

use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\Remote\HttpInterface;

/**
 * File Server API implementation of FileUploader\Server.
 */
class Server extends \Zeedhi\Framework\Remote\FileUploader\Server {

    /**
     * @param HttpInterface $HTTPRequestStrategy cURL strategy implementation
     * @param string $apiKey The organization api key.
     * @param array $headers Headers that will be send on server requests
     */
    public function __construct(HttpInterface $HTTPRequestStrategy, string $apiKey = '', array $headers = []) {
        parent::__construct($HTTPRequestStrategy, $apiKey, $headers);
    }

    /**
     * Performs a GET request and retrieves the content of a file as string.
     * @param DTO\Request $request
     * @return string 
     */
    public function fileRequest(Request $request) {
        $headers = array_merge($this->headers, ['userId' => $request->getUserId()]);
        $this->requestStrategy->setHeaders($headers);
        $this->requestStrategy->setMethod(HttpInterface::METHOD_GET);
        return $this->requestStrategy->request($request->getRoutePath());
    }

}