<?php
namespace tests\Zeedhi\FileServerAPI;

use Zeedhi\FileServerAPI\API;
use Zeedhi\Framework\Remote\Server;
use Zeedhi\Framework\DTO\Request;
use Zeedhi\Framework\DTO\Response;
use Zeedhi\Framework\DataSource\DataSet;
use Zeedhi\Framework\Remote\RequestFactory;

class APITest extends \PHPUnit_Framework_TestCase {

    private $fileServer;
    private $requestFactory;
    private $api;

    public function setUp() {
        $this->fileServer = $this->getMockBuilder(Server::class)
            ->disableOriginalConstructor()
            ->setMethods(['request', 'fileRequest'])
            ->getMock();
        $this->requestFactory = $this->getMockBuilder(RequestFactory::class)
            ->disableOriginalConstructor()
            ->setMethods(['createEmptyRequest', 'createDataSetRequest', 'createRowRequest'])
            ->getMock();
        $this->api = new API($this->fileServer, $this->requestFactory);
    }

    public function testDumpOrganizations() {
        $this->requestFactory->method('createEmptyRequest')->willReturn(new Request('GET', 'organizations', 'user-id'));
        $this->fileServer->method('request')->willReturn(new Response);
        $this->assertEquals([], $this->api->dumpOrganizations());
    }

    public function testCreateOrganization() {
        $this->requestFactory->method('createRowRequest')->willReturn(new Request\Row([], 'GET', 'organization/create', 'user-id'));
        $this->fileServer->method('request')->willReturn(new Response);
        $this->assertEquals([], $this->api->createOrganization([]));
    }

    public function testUpdateOrganization() {
        $this->requestFactory->method('createRowRequest')->willReturn(new Request\Row([], 'GET', 'organization/update', 'user-id'));
        $this->fileServer->method('request')->willReturn(new Response);
        $this->assertEquals([], $this->api->updateOrganization('organization', []));
    }

    public function testDeleteOrganization() {
        $this->requestFactory->method('createRowRequest')->willReturn(new Request\Row([], 'GET', 'organization/delete', 'user-id'));
        $this->fileServer->method('request')->willReturn(new Response);
        $this->assertEquals([], $this->api->deleteOrganization('organization'));
    }

    public function testDumpFiles() {
        $this->requestFactory->method('createEmptyRequest')->willReturn(new Request('GET', 'dump', 'user-id'));
        $this->fileServer->method('request')->willReturn(new Response);
        $this->assertEquals([], $this->api->dumpFiles());
    }

    public function testUploadFile() {
        $this->requestFactory->method('createRowRequest')->willReturn(new Request('GET', 'upload', 'user-id'));
        $this->fileServer->method('request')->willReturn(new Response);
        $this->assertEquals([], $this->api->uploadFile([]));
    }

    public function testUploadFiles() {
        $this->requestFactory->method('createDataSetRequest')->willReturn(new Request\DataSet(new DataSet('files', []), 'GET', 'upload', 'user-id'));
        $this->fileServer->method('request')->willReturn(new Response);
        $this->assertEquals([], $this->api->uploadFiles([]));
    }

    public function testDeleteFile() {
        $this->requestFactory->method('createRowRequest')->willReturn(new Request\Row([], 'GET', 'delete', 'user-id'));
        $this->fileServer->method('request')->willReturn(new Response);
        $this->assertEquals([], $this->api->deleteFile('test.txt'));
    }

    public function testDownloadFile() {
        $this->requestFactory->method('createEmptyRequest')->willReturn(new Request('GET', 'files/test.txt', 'user-id'));
        $this->fileServer->method('fileRequest')->willReturn('content');
        $this->assertEquals('content', $this->api->downloadFile('test.txt'));
    }
}
