<?php
namespace Zeedhi\Framework\DBAL\Driver\OCI8;


use Doctrine\DBAL\DBALException;
use Doctrine\DBAL\Driver\OCI8\OCI8Exception;
use Doctrine\DBAL\Driver\DriverException;
use Zeedhi\Framework\DependencyInjection\InstanceManager;
use Zeedhi\Framework\Util\Functions;

class Driver extends \Doctrine\DBAL\Driver\OCI8\Driver
{
    /**
     * {@inheritdoc}
     */
    public function convertException($message, DriverException $exception) {
        $kernel = InstanceManager::getInstance()->getService('kernel');
        $hidePHPErrors = Functions::getHidePHPErrors();
        $hideOracleErrors = Functions::getHideOracleErrors();

        if($kernel->getIsCriticalError()) {
            if (preg_match('/ORA-\d{5}/', $message, $matches)) {
                $oraCode = intval(str_replace('ORA-', '', $matches[0]));
                if(($oraCode < 20000 || $oraCode > 20999) && $hideOracleErrors) {
                    error_log(Functions::handleOraErrors($message));
                    $message = 'Ocorreu um erro interno. <br> Código: ' . $matches[0];
                }
                return parent::convertException($message, $exception);
            } else if ($hidePHPErrors) {
                trigger_error($message, E_USER_ERROR);
            } else {
                return parent::convertException($message, $exception);
            }
        } else {
            return parent::convertException($message, $exception);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function connect(array $params, $username = null, $password = null, array $driverOptions = array())
    {
        try {
            return new OCI8Connection(
                $username,
                $password,
                $this->_constructDsn($params),
                isset($params['charset']) ? $params['charset'] : null,
                isset($params['sessionMode']) ? $params['sessionMode'] : OCI_DEFAULT,
                isset($params['persistent']) ? $params['persistent'] : false
            );
        } catch (OCI8Exception $e) {
            throw DBALException::driverException($this, $e);
        }
    }

    public function getName() {
        return 'zeedhi_oci8';
    }
}