<?php
namespace Zeedhi\Framework\DataSource\Manager\CustomColumn;

use Zeedhi\Framework\DataSource\Configuration as DataSourceConfiguration;

class Configuration extends DataSourceConfiguration {

    /** @var string[] List of customColumns */
    protected $customColumns = [];

    /**
     * factoryFromJsonData
     * Create Configuration from json data
     *
     * @param  $dataSourceConfig JSON containing the configuration data
     * @param  $dataSourceName   Name of the dataSource
     *
     * @return static
     *
     * @throws Exception
     */
    public static function factoryFromJsonData(array $dataSourceConfig, string $dataSourceName) : DataSourceConfiguration {
        $instance = parent::factoryFromJsonData($dataSourceConfig, $dataSourceName);

        if (isset($dataSourceConfig['customColumns'])) {
            $instance->setCustomColumns($dataSourceConfig['customColumns']);
        }

        return $instance;
    }

    public function getCustomColumns() : array {
        return $this->customColumns;
    }

    public function setCustomColumns(array $customColumns) {
        $this->customColumns = $customColumns;
    }

}