<?php
namespace Zeedhi\Framework\DataSource\Manager\Mongo;

use \Zeedhi\Framework\DataSource\Configuration as DataSourceConfiguration;

/**
 * Class Configuration
 *
 * @package Zeedhi\Framework\DataSource
 */
class Configuration extends DataSourceConfiguration {

    /** @var static[]  */
    protected $internalCollections = array();
    /** @var array  */
    protected $internalCollectionsOptions = array();
    /** @var static  */
    protected $wrapperCollection;
    /** @var array */
    protected $typesMapping = array();
    /** @var static[] */
    protected static $collectionsMap = array();
    /** @var string */
    protected static $dirLocation;

    protected function setWrapperCollection($wrapperCollection) {
        $this->wrapperCollection = self::factoryFromFileLocation(self::$dirLocation, $wrapperCollection);
    }

    protected function setInternalCollections(array $internalCollections) {
        foreach ($internalCollections as $name => $collection) {
            $this->internalCollections[$name] = self::factoryFromFileLocation(self::$dirLocation, $name);
            $this->internalCollectionsOptions[$name] = $collection;
        }
    }

    /**
     * {@inheritDoc}
     */
    protected static function factoryFromJsonData(array $dataSourceConfig, string $dataSourceName) : DataSourceConfiguration {
        /** @var Configuration $instance */
        $instance = parent::factoryFromJsonData($dataSourceConfig, $dataSourceName);
        self::$collectionsMap[$dataSourceName] = $instance;

        $instance->typesMapping = $dataSourceConfig['typesMapping'] ?? $instance->typesMapping;
        $instance->setInternalCollections($dataSourceConfig['internalCollections'] ?? []);
        if (isset($dataSourceConfig['wrapperCollection'])) {
            $instance->setWrapperCollection($dataSourceConfig['wrapperCollection']);
        }
        return $instance;
    }

    /**
     * {@inheritDoc}
     */
    public static function factoryFromFileLocation(string $dirLocation, string $dataSourceName) : DataSourceConfiguration {
        self::$dirLocation = $dirLocation;
        return self::$collectionsMap[$dataSourceName] ?? parent::factoryFromFileLocation($dirLocation, $dataSourceName);
    }

    public function getInternalCollectionOptions($name) {
        return $this->internalCollectionsOptions[$name];
    }

    public function getInternalCollections() {
        return $this->internalCollections;
    }

    /**
     * @param $field
     * @return mixed
     * @throws Exception
     */
    public function getInternalCollectionForField($field) {
        foreach ($this->internalCollectionsOptions as $key => $value) {
            if ($value['fieldName'] === $field) {
                return $this->internalCollections[$key];
            }
        }

        throw Exception::missingInternalCollectionField($field);
    }

    public function getWrapperCollection() {
        return $this->wrapperCollection;
    }

    public function getTypesMapping() {
        return $this->typesMapping;
    }

}