<?php
namespace tests\Zeedhi\Framework\HTTP\Next;

use Zeedhi\Framework\HTTP\Next\RequestFactory;
use Zeedhi\Framework\DependencyInjection\InstanceManager;
use tests\Zeedhi\Framework\HTTP\RequestTest;

class RequestFactoryTest extends \PHPUnit\Framework\TestCase {

    public function setUp() {
        $instanceManager = InstanceManager::getInstance();
    }

    public function testBuildGetRequestWithQuery() {
        $expectedConditions = [
            [
                'columnName' => 'COUNTRY_ID',
                'operator'   => '=',
                'value'      => 'AR'
            ],
            [
                'columnName' => 'COUNTRY_NAME',
                'operator'   => '=',
                'value'      => 'Argentina'
            ]
        ];
        $expectedClass = 'Zeedhi\Framework\DTO\Request\Filter';
        $expectedDataSourceName = 'countries';
        $httpRequest = RequestTest::create('http://pokemon:pokemon@example.net:9090/index.php/countries?COUNTRY_NAME=Argentina&COUNTRY_ID=AR&in=COUNTRY_ID&in=COUNTRY_NAME', 'GET');
        $parser = new RequestFactory($httpRequest, "index.php");
        $dtoRequest = $parser->buildRequest();
        $this->assertEquals($expectedClass, get_class($dtoRequest));
        $this->assertEquals($expectedConditions, $dtoRequest->getFilterCriteria()->getConditions());
        $this->assertEquals($expectedDataSourceName, $dtoRequest->getFilterCriteria()->getDataSourceName());
    }

    public function testBuildPostRequestWithQuery() {
        $expectedClass = 'Zeedhi\Framework\DTO\Request\DataSet';
        $expectedRow = ['name' => 'Mateus'];
        $expectedDataSourceName = 'countries';
        $httpRequest = RequestTest::create('http://pokemon:pokemon@example.net:9090/index.php/countries?name=Mateus', 'POST');
        $parser = new RequestFactory($httpRequest, "index.php");
        $dtoRequest = $parser->buildRequest();
        $this->assertEquals($expectedClass, get_class($dtoRequest));
        $this->assertEquals($expectedRow, $dtoRequest->getDataSet()->getRows()[0]);
        $this->assertEquals($expectedDataSourceName, $dtoRequest->getDataSet()->getDataSourceName());
    }

    public function testBuildGetRequestWithSearch() {
        $httpRequest = RequestTest::create('http://pokemon:pokemon@example.net:9090/index.php/countries/1?search=Mateus Barbosa');
        $parser = new RequestFactory($httpRequest, "index.php");
        $dtoRequest = $parser->buildRequest();
        $filterCriteria = $dtoRequest->getFilterCriteria();
        $expectedSearch = ["Mateus", "Barbosa"];
        $this->assertEquals($expectedSearch, $filterCriteria->getSearch());
    }

    public function testBuildGetRequestWithSearchIn() {
        $httpRequest = RequestTest::create('http://pokemon:pokemon@example.net:9090/index.php/countries/1?search_in=first_name&search_in=last_name&search_in=email');
        $parser = new RequestFactory($httpRequest, "index.php");
        $dtoRequest = $parser->buildRequest();
        $filterCriteria = $dtoRequest->getFilterCriteria();
        $expectedSearchIn = ["first_name", "last_name", "email"];
        $this->assertEquals($expectedSearchIn, $filterCriteria->getSearchIn());
    }

    public function testBuildGetRequestWithOrderBy() {
        $httpRequest = RequestTest::create('http://pokemon:pokemon@example.net:9090/index.php/countries/1?order=first_name.asc', 'GET');
        $parser = new RequestFactory($httpRequest, "index.php");
        $dtoRequest = $parser->buildRequest();
        $filterCriteria = $dtoRequest->getFilterCriteria();
        $expectedOrderBy = ["first_name" => "asc"];
        $this->assertEquals($expectedOrderBy, $filterCriteria->getOrderBy());
    }
}
