<?php
namespace Zeedhi\Framework\DataSource;

use Zeedhi\Framework\Cache\Cache;

class ParameterBag {

    /** @var Cache */
    protected $cache;

    public function __construct(Cache $cache) {
        $this->cache = $cache;
    }

    /**
     * @param $name
     * @return string
     */
    protected function prefixName($name) {
        return 'zeedhi_data_source_param_' . $name;
    }

    public function set($name, $value) {
        $this->cache->save($this->prefixName($name), $value);
    }

    public function get($name) {
        return $this->cache->fetch($this->prefixName($name));
    }

    /**
     * Retrieves the value for key if exists or else the default value.
     * @param mixed $key     The key to search on cache.
     * @param mixed $default The value to retrieve if the key have no match.
     * @return mixed
     */
    public function getOrDefault($key, $default = null) {
        return $this->has($key) ? $this->get($key) : $default;
    }

    /**
     * Declares if the key is set.
     * @param mixed $key     The key to search on cache.
     * @return bool
     */
    public function has($key) : bool {
        return $this->cache->contains($this->prefixName($key));
    }
}