<?php
namespace Zeedhi\Framework\DBAL\Driver\OCI8;

use Zeedhi\Framework\DependencyInjection\InstanceManager;

class OCI8Statement extends \Doctrine\DBAL\Driver\OCI8\OCI8Statement {

    protected $fieldTypes = null;
    protected $fieldNames = null;
    protected $fieldIdByName = null;
    protected $thousandsSeparator = ',';
    protected $decimalSeparator = '.';
    protected $setSeparator = true;

    protected function loadResultSetMetaData() {
        if ($this->fieldTypes === null) {
            $this->fieldNames = $this->fieldIdByName = $this->fieldTypes = array();
            $ociFieldNum = oci_num_fields($this->_sth);
            for ($i = 1; $i <= $ociFieldNum; $i++) {
                $fieldName = oci_field_name($this->_sth, $i);
                $this->fieldTypes[$i] = oci_field_type($this->_sth, $i);
                $this->fieldNames[$i] = $fieldName;
                $this->fieldIdByName[$fieldName] = $i;
            }
        }
    }

    public function normalizeFloatString($value) {
        // Remove thousands delimiter char and replace decimal dots.
        return str_replace($this->decimalSeparator, ".", str_replace($this->thousandsSeparator, "", $value));
    }

    protected function normalizeValueByType($value, $type) {
        if ($type === 'NUMBER' && $value !== null) {
            $value = floatval($this->normalizeFloatString($value));
        }

        return $value;
    }

    protected function setnormalizeFloat() {
        // This is know due to OracleSessionInit.
        try {
            if ($this->setSeparator) {
                /** @var OracleSessionInit $sessionInit */
                $sessionInit = InstanceManager::getInstance()->getService('crudSessionInit');
                $defaultSessionVars = $sessionInit->getDefaultSessionVars();
                $nlsNumericCharacters = $defaultSessionVars['NLS_NUMERIC_CHARACTERS'];
                $this->decimalSeparator = $nlsNumericCharacters[0];
                $this->thousandsSeparator = $nlsNumericCharacters[1];
                $this->setSeparator = false;
            }
        }catch (\Exception $e){
            $this->decimalSeparator = '.';
            $this->thousandsSeparator = ',';
        }
    }

    protected function inferTypes($result, $fetchMode) {
        $this->setnormalizeFloat();
        $this->loadResultSetMetaData();
        switch ($fetchMode ?: $this->_defaultFetchMode) {
            case \PDO::FETCH_BOTH:
                foreach($result as $key => $value) {
                    $fieldId = !is_numeric($key) ? $this->fieldIdByName[$key] : $key+1;
                    $result[$key] = $this->normalizeValueByType($value, $this->fieldTypes[$fieldId]);
                }
                break;
            case \PDO::FETCH_ASSOC:
                foreach($result as $key => $value) {
                    $fieldId = $this->fieldIdByName[$key];
                    $result[$key] = $this->normalizeValueByType($value, $this->fieldTypes[$fieldId]);
                }
                break;
            case \PDO::FETCH_NUM:
            case \PDO::FETCH_COLUMN:

                if(!is_array($result)){
                    return [$result];
                }

                foreach($result as $key => $value) {
                    $result[$key] = $this->normalizeValueByType($value, $this->fieldTypes[$key+1]);
                }
                break;
        }

        return $result;
    }

    public function fetch($fetchMode = null, $cursorOrientation = \PDO::FETCH_ORI_NEXT, $cursorOffset = 0) {
        $result = parent::fetch($fetchMode, $cursorOrientation, $cursorOffset);
        return $result ? $this->inferTypes($result, $fetchMode) : $result;
    }

    protected function normalizeFetchAllResultSet($fetchMode, $rows) {
        $fetchMode = $fetchMode ?: $this->_defaultFetchMode;
        //The OCI_BOTH mode is normalized by fetch method, even if called by fetch all.
        if (self::$fetchModeMap[$fetchMode] !== OCI_BOTH) {
            foreach ($rows as &$row) {
                $row = $this->inferTypes($row, $fetchMode);
            }
        }

        return $rows;
    }

    public function fetchAll($fetchMode = null, $fetchArgument = null, $ctorArgs = null) {
        $rows = parent::fetchAll($fetchMode, $fetchArgument, $ctorArgs);
        return $this->normalizeFetchAllResultSet($fetchMode, $rows);
    }

    public function bindParam($column, &$variable, $type = null, $length = null) {
        $column = isset($this->_paramMap[$column]) ? $this->_paramMap[$column] : $column;

        if ($type == \PDO::PARAM_LOB) {
            $lob = oci_new_descriptor($this->_dbh, OCI_D_LOB);
            $lob->writeTemporary($variable, OCI_TEMP_BLOB);

            return oci_bind_by_name($this->_sth, $column, $lob, -1, OCI_B_BLOB);
        } elseif ($type === SQLT_LBI){
            return oci_bind_by_name($this->_sth, $column, $variable, strlen($variable), $type);
        } elseif ($length !== null) {
            return oci_bind_by_name($this->_sth, $column, $variable, $length);
        }

        return oci_bind_by_name($this->_sth, $column, $variable);
    }
}
