<?php
namespace tests\Zeedhi\Framework\Service;

use Zeedhi\Framework\Service\Next;
use HumanRelation\Util\DataSource\NameProvider;

class NextTest extends \PHPUnit\Framework\TestCase {

    /** @var Next */
    private $next;

    public function setUp() {
        $this->next = new Next(new NameProvider());
    }

    public function testGetDataSourceNameFromSimpleUri() {
        $arrayUri = [
            "countries"
        ];
        $dataSourceName = $this->next->getDataSourceName($arrayUri);
        $this->assertEquals("countries", $dataSourceName);
    }

    public function testGetDataSourceNameFromNestedUri() {
        $arrayUri = [
            "employees",
            "{EMPLOYEE_ID}",
            "countries",
            "{COUNTRY_ID}"
        ];
        $dataSourceName = $this->next->getDataSourceName($arrayUri);
        $this->assertEquals("countries", $dataSourceName);
    }

    public function testGetDataSourceNameFromCompoundUri() {
        $arrayUri = [
            "job_history",
            "{START_DATE}",
            "{EMPLOYEE_ID}"
        ];
        $dataSourceName = $this->next->getDataSourceName($arrayUri);
        $this->assertEquals("job_history", $dataSourceName);
    }

    public function testBuildArrayUri() {
        $expectedArrayUri = [
            "countries",
            "{COUNTRY_ID}",
            "employees",
            "{EMPLOYEE_ID}"
        ];
        $uri = "/countries/{COUNTRY_ID}/employees/{EMPLOYEE_ID}";
        $arrayUri = Next::buildArrayUri($uri);
        $this->assertEquals($expectedArrayUri, $arrayUri);
    }
}