<?php

namespace Zeedhi\Framework\Util;

class QuerySelector
{

    const DRIVER_AS_NULL_FORCE = array(
        'pdo_pgsql'
    );
    const DRIVER_AS_LIKE_FORCE = array(
        'pdo_pgsql'
    );
    const DRIVER_AS_IN_QUERY = array(
        'pdo_pgsql'
    );
    const SAME_DRIVER_QUERY = array(
        'oci9' => 'oci8'
    );

    public static function getQueryByDriver(\Doctrine\DBAL\Connection $conn, array $arrayQueries)
    {
        $driverName = $conn->getDriver()->getDatabasePlatform()->getName();
        $query = null;
        if (!empty($arrayQueries['default'])) {
            $query = $arrayQueries['default'];
        }
        if (!empty($arrayQueries[$driverName])) {
            $query = $arrayQueries[$driverName];
        } else if (!empty(self::SAME_DRIVER_QUERY[$driverName]) && !empty($arrayQueries[self::SAME_DRIVER_QUERY[$driverName]])) {
            $query = $arrayQueries[self::SAME_DRIVER_QUERY[$driverName]];
        }
        if (!$query) {
            throw new \Exception('ERROR_QUERY_NOT_FOUND');
        }
        return $query;
    }
}

