<?php
namespace Zeedhi\Framework\DB\StoredProcedure\Strategies;

use Doctrine\DBAL\Connection;
use Zeedhi\Framework\DB\StoredProcedure\DataBaseStrategy;

class StrategyFactory {

    /**
     * @param Connection $connection
     *
     * @return DataBaseStrategy
     *
     * @throws \Exception
     */
    public static function createStrategy(Connection $connection) {
        $strategy = null;
        switch ($connection->getDriver()->getDatabasePlatform()->getName()) {
            case 'oci8':
            case 'oracle':
            case 'zeedhi_oci8':
                $strategy = new OracleStrategy($connection);
                break;
            case 'mssql':
            case 'sqlsrv':
                $strategy = new SQLServerStrategy($connection);
                break;
            case 'pdo_dblib':
                $strategy = new DBLibStrategy($connection);
                break;
            case 'postgresql':
            case 'pdo_pgsql':
                $strategy = new PostgreStrategy($connection);
                break;
            default:
                throw Exception::unsupportedDriver($connection->getDriver()->getDatabasePlatform()->getName());
                break;
        }

        return $strategy;
    }
}