<?php
namespace Zeedhi\Framework\DBAL\Driver\OCI8;


use Doctrine\DBAL\DBALException;
use Doctrine\DBAL\Driver\OCI8\Connection;
use Doctrine\DBAL\Driver\OCI8\Exception\ConnectionFailed;
use Doctrine\DBAL\Driver\OCI8\Exception\InvalidConfiguration;
use Doctrine\DBAL\Driver\OCI8\OCI8Exception;
use Doctrine\DBAL\Driver\DriverException;
use Zeedhi\Framework\DependencyInjection\InstanceManager;
use Zeedhi\Framework\Util\Functions;
use Doctrine\DBAL\Driver\AbstractOracleDriver;
use Doctrine\DBAL\Driver\OCI8\Driver as DoctrineOCI8Driver;

class Driver extends AbstractOracleDriver
{
    /**
     * {@inheritdoc}
     */
//    public function convertException($message, DriverException $exception) {
//        $kernel = InstanceManager::getInstance()->getService('kernel');
//        $hidePHPErrors = Functions::getHidePHPErrors();
//        $hideOracleErrors = Functions::getHideOracleErrors();
//
//        if($kernel->getIsCriticalError()) {
//            if (preg_match('/ORA-\d{5}/', $message, $matches)) {
//                $oraCode = intval(str_replace('ORA-', '', $matches[0]));
//                if(($oraCode < 20000 || $oraCode > 20999) && $hideOracleErrors) {
//                    error_log(Functions::handleOraErrors($message));
//                    $message = 'Ocorreu um erro interno. <br> Código: ' . $matches[0];
//                }
//                return parent::convertException($message, $exception);
//            } else if ($hidePHPErrors) {
//                trigger_error($message, E_USER_ERROR);
//            } else {
//                return parent::convertException($message, $exception);
//            }
//        } else {
//            return parent::convertException($message, $exception);
//        }
//    }

    public function connect(
        array $params
    )
    {
        $username = $params['user'] ?? '';
        $password = $params['password'] ?? '';
        $charset = $params['charset'] ?? '';
        $sessionMode = $params['sessionMode'] ?? OCI_NO_AUTO_COMMIT;

        $connectionString = $this->getEasyConnectString($params);

        $persistent = !empty($params['persistent']);
        $exclusive = !empty($params['driverOptions']['exclusive']);

        if ($persistent && $exclusive) {
            throw InvalidConfiguration::forPersistentAndExclusive();
        }

        if ($persistent) {
            $connection = @oci_pconnect($username, $password, $connectionString, $charset, $sessionMode);
        } elseif ($exclusive) {
            $connection = @oci_new_connect($username, $password, $connectionString, $charset, $sessionMode);
        } else {
            $connection = @oci_connect($username, $password, $connectionString, $charset, $sessionMode);
        }

        if ($connection === false) {
            throw ConnectionFailed::new();
        }

        return new \Zeedhi\Framework\DBAL\Driver\OCI8\OCI8Connection($connection);
    }

    public function getName() {
        return 'zeedhi_oci8';
    }
}