<?php
namespace Zeedhi\Framework\ORM;

class DateTime extends \DateTime{

    public function __toString() {
        return $this->format("d/m/Y H:i:s");
    }

    public static function createFromFormat(
        string $format,
        string $datetime,
        ?\DateTimeZone $timezone = null
    ): DateTime|false  {
        $ext_dt = false;
        $originalClassObject = parent::createFromFormat($format, $datetime);
        if ($originalClassObject) {
            $ext_dt = new static();
            $ext_dt->setTimestamp($originalClassObject->getTimestamp());
        }

        return $ext_dt;
    }

} 