<?php
namespace Zeedhi\Framework\DataSource\Manager\IdProvider\Providers;

use Doctrine\DBAL\Connection;
use Zeedhi\Framework\DataSource\Manager\IdProvider\IdProvider;
use Zeedhi\Framework\File\Exception;

class SqlSequence implements IdProvider {

    /** @var Connection */
    protected $connection;

    /**
     * Construct
     *
     * @param Connection $connection
     */
    public function __construct(Connection $connection) {
        $this->connection = $connection;
    }

    /**
     * Generates a new code on sequence for column.
     *
     * @param string $tableName  Table name.
     * @param string $columnName Column name.
     *
     * @return int
     */
    public function getNextId(string $tableName, string $columnName) : int {
        $sequenceName = $this->getSequenceName($tableName, $columnName);
        $query = $this->connection->getDatabasePlatform()->getSequenceNextValSQL($sequenceName);
        $sequenceVal = $this->connection->fetchAssoc($query);
        return intval($sequenceVal['NEXTVAL']);
    }

    /**
     * Geenrates sequence name.
     *
     * @param string $tableName  Table name.
     * @param string $columnName Column name.
     *
     * @return string The sequence name.
     */
    private function getSequenceName(string $tableName, string $columnName) : string {
        $sequenceName = "SEQ_" . str_replace("ZH", "", str_replace("TKU", "", $tableName));
        $sequenceName .= $columnName == "ID" ? "" : "_" . $columnName;
        return $sequenceName;
    }
}