<?php
namespace tests\Zeedhi\Framework\DTO\Next;

use Zeedhi\Framework\DTO\Next\Response;
use Zeedhi\Framework\DTO\Row;
use Zeedhi\Framework\DataSource\DataSet;

class ResponseTest extends \PHPUnit\Framework\TestCase {

    public function testSetRow() {
        $row = ['name' => 'Mateus'];
        $response = new Response();
        $response->setRow($row);
        $this->assertEquals('Mateus', $response->getRow()['name']);
    }

    public function testSetDataSet() {
        $dataSet = new DataSet('users', ['name' => 'Mateus']);
        $response = new Response();
        $response->setDataSet($dataSet);
        $this->assertEquals('Mateus', $response->getDataSet()->getRows()['name']);
    }

    public function testSetUri() {
        $response = new Response();
        $response->setDataSourceName('users');
        $this->assertEquals('users', $response->getDatasourceName());
    }

    public function testPrimaryKeyColumns() {
        $primaryKeyColumns = ['ID'];
        $response = new Response();
        $response->setPrimaryKeyColumns($primaryKeyColumns);
        $this->assertEquals($primaryKeyColumns, $response->getPrimaryKeyColumns());
    }

    public function testGetLink() {
        $response = new Response();
        $this->assertEquals(
            'https://localhost:9090/users/1/2',
            $response->getLink('https://localhost:9090', '/users', '/1/2')
        );
    }
}
