<?php
namespace tests\Zeedhi\Framework\Routing\Next;

use HumanRelation\Util\DataSource\NameProvider;
use Zeedhi\Framework\Routing\Next\RouteFactory;
use Zeedhi\Framework\Routing\Route;
use Zeedhi\Framework\Routing\Router;
use Zeedhi\Framework\DTO;

class RouteFactoryTest extends \PHPUnit\Framework\TestCase {

    private $routeFactory;

    public function setUp() {
        $this->routeFactory = new RouteFactory(new NameProvider());
    }

    public function testBuildBasicRequestWithoutControllerDefault() {
        $expectedRoute = new Route(
            ['GET'],
            '/employees',
            'testController',
            'testMethod',
            DTO\Request::TYPE_NEXT,
            []
        );
        $this->routeFactory->buildRoute('/employees', 'GET', 'testMethod', 'testController');
        $route = Router::getRouteByPath('/employees', 'GET');
        $this->assertEquals($route, $expectedRoute);
    }

    public function testBuildBasicRequest() {
        $expectedRoute = new Route(
            ['GET'],
            '/countries',
            RouteFactory::CONTROLLER_NAME,
            'find',
            DTO\Request::TYPE_NEXT,
            []
        );
        $this->routeFactory->buildRoute('/countries', 'GET');
        $route = Router::getRouteByPath('/countries', 'GET');
        $this->assertEquals($route, $expectedRoute);
    }

    public function testBuildBasicRequestWithParameters() {
        $expectedRoute = new Route(
            ['GET'],
            '/countries/{COUNTRY_ID}',
            RouteFactory::CONTROLLER_NAME,
            'find',
            DTO\Request::TYPE_NEXT,
            [
                [
                    "name"  => "COUNTRY_ID",
                    "regex" => ".+"
                ]
            ]
        );
        $this->routeFactory->buildRoute('/countries/{COUNTRY_ID}', 'GET');
        $route = Router::getRouteByPath('/countries/{COUNTRY_ID}', 'GET');
        $this->assertEquals($route, $expectedRoute);
    }

    public function testBuildNestedRequest() {
        $expectedRoute = new Route(
            ['GET'],
            '/countries/{COUNTRY_ID}/employees',
            RouteFactory::CONTROLLER_NAME,
            'find',
            DTO\Request::TYPE_NEXT,
            [
                [
                    "name"  => "COUNTRY_ID",
                    "regex" => ".+"
                ]
            ]
        );
        $this->routeFactory->buildRoute('/countries/{COUNTRY_ID}/employees', 'GET');
        $route = Router::getRouteByPath('/countries/{COUNTRY_ID}/employees', 'GET');
        $this->assertEquals($route, $expectedRoute);
    }

    public function testBuildNestedRequestWithParameters() {
        $expectedRoute = new Route(
            ['GET'],
            '/countries/{COUNTRY_ID}/employees/{EMPLOYEE_ID}',
            RouteFactory::CONTROLLER_NAME,
            'find',
            DTO\Request::TYPE_NEXT,
            [
                [
                    "name"  => "COUNTRY_ID",
                    "regex" => ".+"
                ],
                [
                    "name"  => "EMPLOYEE_ID",
                    "regex" => ".+"
                ]
            ]
        );
        $this->routeFactory->buildRoute('/countries/{COUNTRY_ID}/employees/{EMPLOYEE_ID}', 'GET');
        $route = Router::getRouteByPath('/countries/{COUNTRY_ID}/employees/{EMPLOYEE_ID}', 'GET');
        $this->assertEquals($route, $expectedRoute);
    }

    public function testBuildCompoundRequest() {
        $expectedRoute = new Route(
            ['GET'],
            '/job_history/{START_DATE}/{EMPLOYEE_ID}',
            RouteFactory::CONTROLLER_NAME,
            'find',
            DTO\Request::TYPE_NEXT,
            [
                [
                    "name"  => "START_DATE",
                    "regex" => ".+"
                ],
                [
                    "name"  => "EMPLOYEE_ID",
                    "regex" => ".+"
                ]
            ]
        );
        $this->routeFactory->buildRoute('/job_history/{START_DATE}/{EMPLOYEE_ID}', 'GET');
        $route = Router::getRouteByPath('/job_history/{START_DATE}/{EMPLOYEE_ID}', 'GET');
        $this->assertEquals($route, $expectedRoute);
    }
}