<?php

namespace Zeedhi\Framework\DBAL\Driver\OCI8;

use Doctrine\DBAL\Driver\API\ExceptionConverter as ExceptionConverterInterface;
use Doctrine\DBAL\Driver\Exception;
use Doctrine\DBAL\Exception\DriverException;
use Doctrine\DBAL\Query;
use Zeedhi\Framework\DependencyInjection\InstanceManager;
use Zeedhi\Framework\Util\Functions;


class ExceptionConverter implements ExceptionConverterInterface
{
    public function convert(Exception $exception, ?Query $query): DriverException
    {
        $kernel = InstanceManager::getInstance()->getService('kernel');
        $hidePHPErrors = Functions::getHidePHPErrors();
        $hideOracleErrors = Functions::getHideOracleErrors();
        $message = $exception->getMessage();
        if($kernel->getIsCriticalError()) {
            if (preg_match('/ORA-\d{5}/', $message, $matches)) {
                $oraCode = intval(str_replace('ORA-', '', $matches[0]));
                if(($oraCode < 20000 || $oraCode > 20999) && $hideOracleErrors) {
                    error_log(Functions::handleOraErrors($message));
                    $message = 'Ocorreu um erro interno. <br> Código: ' . $matches[0];
                } 
                $exceptionNew =  new \Doctrine\DBAL\Driver\OCI8\Exception\Error($message);
                return Driver::convertExceptionParentStatic()->convert($exceptionNew,$query);
            } else if ($hidePHPErrors) {
                trigger_error($message, E_USER_ERROR);
            } else {
                return Driver::convertExceptionParentStatic()->convert($exception,$query);
            }
        } else {
            return Driver::convertExceptionParentStatic()->convert($exception,$query);
        }
    }
}
